/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class VillagerProfession {
    public static final VillagerProfession NONE = VillagerProfession.register("none", VillagePlaceType.UNEMPLOYED, null);
    public static final VillagerProfession ARMORER = VillagerProfession.register("armorer", VillagePlaceType.ARMORER, SoundEffects.VILLAGER_WORK_ARMORER);
    public static final VillagerProfession BUTCHER = VillagerProfession.register("butcher", VillagePlaceType.BUTCHER, SoundEffects.VILLAGER_WORK_BUTCHER);
    public static final VillagerProfession CARTOGRAPHER = VillagerProfession.register("cartographer", VillagePlaceType.CARTOGRAPHER, SoundEffects.VILLAGER_WORK_CARTOGRAPHER);
    public static final VillagerProfession CLERIC = VillagerProfession.register("cleric", VillagePlaceType.CLERIC, SoundEffects.VILLAGER_WORK_CLERIC);
    public static final VillagerProfession FARMER = VillagerProfession.register("farmer", VillagePlaceType.FARMER, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.WHEAT, (Object)Items.WHEAT_SEEDS, (Object)Items.BEETROOT_SEEDS, (Object)Items.BONE_MEAL), (ImmutableSet<Block>)ImmutableSet.of((Object)Blocks.FARMLAND), SoundEffects.VILLAGER_WORK_FARMER);
    public static final VillagerProfession FISHERMAN = VillagerProfession.register("fisherman", VillagePlaceType.FISHERMAN, SoundEffects.VILLAGER_WORK_FISHERMAN);
    public static final VillagerProfession FLETCHER = VillagerProfession.register("fletcher", VillagePlaceType.FLETCHER, SoundEffects.VILLAGER_WORK_FLETCHER);
    public static final VillagerProfession LEATHERWORKER = VillagerProfession.register("leatherworker", VillagePlaceType.LEATHERWORKER, SoundEffects.VILLAGER_WORK_LEATHERWORKER);
    public static final VillagerProfession LIBRARIAN = VillagerProfession.register("librarian", VillagePlaceType.LIBRARIAN, SoundEffects.VILLAGER_WORK_LIBRARIAN);
    public static final VillagerProfession MASON = VillagerProfession.register("mason", VillagePlaceType.MASON, SoundEffects.VILLAGER_WORK_MASON);
    public static final VillagerProfession NITWIT = VillagerProfession.register("nitwit", VillagePlaceType.NITWIT, null);
    public static final VillagerProfession SHEPHERD = VillagerProfession.register("shepherd", VillagePlaceType.SHEPHERD, SoundEffects.VILLAGER_WORK_SHEPHERD);
    public static final VillagerProfession TOOLSMITH = VillagerProfession.register("toolsmith", VillagePlaceType.TOOLSMITH, SoundEffects.VILLAGER_WORK_TOOLSMITH);
    public static final VillagerProfession WEAPONSMITH = VillagerProfession.register("weaponsmith", VillagePlaceType.WEAPONSMITH, SoundEffects.VILLAGER_WORK_WEAPONSMITH);
    private final String name;
    private final VillagePlaceType jobPoiType;
    private final ImmutableSet<Item> requestedItems;
    private final ImmutableSet<Block> secondaryPoi;
    @Nullable
    private final SoundEffect workSound;

    private VillagerProfession(String var0, VillagePlaceType var1, ImmutableSet<Item> var2, ImmutableSet<Block> var3, @Nullable SoundEffect var4) {
        this.name = var0;
        this.jobPoiType = var1;
        this.requestedItems = var2;
        this.secondaryPoi = var3;
        this.workSound = var4;
    }

    public String getName() {
        return this.name;
    }

    public VillagePlaceType getJobPoiType() {
        return this.jobPoiType;
    }

    public ImmutableSet<Item> getRequestedItems() {
        return this.requestedItems;
    }

    public ImmutableSet<Block> getSecondaryPoi() {
        return this.secondaryPoi;
    }

    @Nullable
    public SoundEffect getWorkSound() {
        return this.workSound;
    }

    public String toString() {
        return this.name;
    }

    static VillagerProfession register(String var0, VillagePlaceType var1, @Nullable SoundEffect var2) {
        return VillagerProfession.register(var0, var1, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), var2);
    }

    static VillagerProfession register(String var0, VillagePlaceType var1, ImmutableSet<Item> var2, ImmutableSet<Block> var3, @Nullable SoundEffect var4) {
        return IRegistry.register(IRegistry.VILLAGER_PROFESSION, new MinecraftKey(var0), new VillagerProfession(var0, var1, var2, var3, var4));
    }
}

