/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.IRegistry;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;

public class VillagerData {
    public static final int MIN_VILLAGER_LEVEL = 1;
    public static final int MAX_VILLAGER_LEVEL = 5;
    private static final int[] NEXT_LEVEL_XP_THRESHOLDS = new int[]{0, 10, 70, 150, 250};
    public static final Codec<VillagerData> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)IRegistry.VILLAGER_TYPE.byNameCodec().fieldOf("type").orElseGet(() -> VillagerType.PLAINS).forGetter(var0 -> var0.type), (App)IRegistry.VILLAGER_PROFESSION.byNameCodec().fieldOf("profession").orElseGet(() -> VillagerProfession.NONE).forGetter(var0 -> var0.profession), (App)Codec.INT.fieldOf("level").orElse((Object)1).forGetter(var0 -> var0.level)).apply((Applicative)var02, VillagerData::new));
    private final VillagerType type;
    private final VillagerProfession profession;
    private final int level;

    public VillagerData(VillagerType var0, VillagerProfession var1, int var2) {
        this.type = var0;
        this.profession = var1;
        this.level = Math.max(1, var2);
    }

    public VillagerType getType() {
        return this.type;
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    public int getLevel() {
        return this.level;
    }

    public VillagerData setType(VillagerType var0) {
        return new VillagerData(var0, this.profession, this.level);
    }

    public VillagerData setProfession(VillagerProfession var0) {
        return new VillagerData(this.type, var0, this.level);
    }

    public VillagerData setLevel(int var0) {
        return new VillagerData(this.type, this.profession, var0);
    }

    public static int getMinXpPerLevel(int var0) {
        return VillagerData.canLevelUp(var0) ? NEXT_LEVEL_XP_THRESHOLDS[var0 - 1] : 0;
    }

    public static int getMaxXpPerLevel(int var0) {
        return VillagerData.canLevelUp(var0) ? NEXT_LEVEL_XP_THRESHOLDS[var0] : 0;
    }

    public static boolean canLevelUp(int var0) {
        return var0 >= 1 && var0 < 5;
    }
}

