/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCrossbowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public class EntityPillager
extends EntityIllagerAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> IS_CHARGING_CROSSBOW = DataWatcher.defineId(EntityPillager.class, DataWatcherRegistry.BOOLEAN);
    private static final int INVENTORY_SIZE = 5;
    private static final int SLOT_OFFSET = 300;
    private static final float CROSSBOW_POWER = 1.6f;
    public final InventorySubcontainer inventory = new InventorySubcontainer(5);

    public EntityPillager(EntityTypes<? extends EntityPillager> var0, World var1) {
        super((EntityTypes<? extends EntityIllagerAbstract>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(2, new EntityRaider.a(this, 10.0f));
        this.goalSelector.addGoal(3, new PathfinderGoalCrossbowAttack<EntityPillager>(this, 1.0, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 15.0f));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.35f).add(GenericAttributes.MAX_HEALTH, 24.0).add(GenericAttributes.ATTACK_DAMAGE, 5.0).add(GenericAttributes.FOLLOW_RANGE, 32.0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(IS_CHARGING_CROSSBOW, false);
    }

    @Override
    public boolean canFireProjectileWeapon(ItemProjectileWeapon var0) {
        return var0 == Items.CROSSBOW;
    }

    public boolean isChargingCrossbow() {
        return this.entityData.get(IS_CHARGING_CROSSBOW);
    }

    @Override
    public void setChargingCrossbow(boolean var0) {
        this.entityData.set(IS_CHARGING_CROSSBOW, var0);
    }

    @Override
    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        NBTTagList var1 = new NBTTagList();
        for (int var2 = 0; var2 < this.inventory.getContainerSize(); ++var2) {
            ItemStack var3 = this.inventory.getItem(var2);
            if (var3.isEmpty()) continue;
            var1.add(var3.save(new NBTTagCompound()));
        }
        var0.put("Inventory", var1);
    }

    @Override
    public EntityIllagerAbstract.a getArmPose() {
        if (this.isChargingCrossbow()) {
            return EntityIllagerAbstract.a.CROSSBOW_CHARGE;
        }
        if (this.isHolding(Items.CROSSBOW)) {
            return EntityIllagerAbstract.a.CROSSBOW_HOLD;
        }
        if (this.isAggressive()) {
            return EntityIllagerAbstract.a.ATTACKING;
        }
        return EntityIllagerAbstract.a.NEUTRAL;
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        NBTTagList var1 = var0.getList("Inventory", 10);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            ItemStack var3 = ItemStack.of(var1.getCompound(var2));
            if (var3.isEmpty()) continue;
            this.inventory.addItem(var3);
        }
        this.setCanPickUpLoot(true);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        this.populateDefaultEquipmentSlots(var1);
        this.populateDefaultEquipmentEnchantments(var1);
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    @Override
    protected void populateDefaultEquipmentSlots(DifficultyDamageScaler var0) {
        this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.CROSSBOW));
    }

    @Override
    protected void enchantSpawnedWeapon(float var0) {
        ItemStack var1;
        super.enchantSpawnedWeapon(var0);
        if (this.random.nextInt(300) == 0 && (var1 = this.getMainHandItem()).is(Items.CROSSBOW)) {
            Map<Enchantment, Integer> var2 = EnchantmentManager.getEnchantments(var1);
            var2.putIfAbsent(Enchantments.PIERCING, 1);
            EnchantmentManager.setEnchantments(var2, var1);
            this.setItemSlot(EnumItemSlot.MAINHAND, var1);
        }
    }

    @Override
    public boolean isAlliedTo(Entity var0) {
        if (super.isAlliedTo(var0)) {
            return true;
        }
        if (var0 instanceof EntityLiving && ((EntityLiving)var0).getMobType() == EnumMonsterType.ILLAGER) {
            return this.getTeam() == null && var0.getTeam() == null;
        }
        return false;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.PILLAGER_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PILLAGER_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PILLAGER_HURT;
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        this.performCrossbowAttack(this, 1.6f);
    }

    @Override
    public void shootCrossbowProjectile(EntityLiving var0, ItemStack var1, IProjectile var2, float var3) {
        this.shootCrossbowProjectile(this, var0, var2, var3, 1.6f);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected void pickUpItem(EntityItem var0) {
        ItemStack var1 = var0.getItem();
        if (var1.getItem() instanceof ItemBanner) {
            super.pickUpItem(var0);
        } else if (this.wantsItem(var1)) {
            this.onItemPickup(var0);
            ItemStack var2 = this.inventory.addItem(var1);
            if (var2.isEmpty()) {
                var0.discard();
            } else {
                var1.setCount(var2.getCount());
            }
        }
    }

    private boolean wantsItem(ItemStack var0) {
        return this.hasActiveRaid() && var0.is(Items.WHITE_BANNER);
    }

    @Override
    public SlotAccess getSlot(int var0) {
        int var1 = var0 - 300;
        if (var1 >= 0 && var1 < this.inventory.getContainerSize()) {
            return SlotAccess.forContainer(this.inventory, var1);
        }
        return super.getSlot(var0);
    }

    @Override
    public void applyRaidBuffs(int var0, boolean var1) {
        boolean var3;
        Raid var2 = this.getCurrentRaid();
        boolean bl = var3 = this.random.nextFloat() <= var2.getEnchantOdds();
        if (var3) {
            ItemStack var4 = new ItemStack(Items.CROSSBOW);
            HashMap var5 = Maps.newHashMap();
            if (var0 > var2.getNumGroups(EnumDifficulty.NORMAL)) {
                var5.put(Enchantments.QUICK_CHARGE, 2);
            } else if (var0 > var2.getNumGroups(EnumDifficulty.EASY)) {
                var5.put(Enchantments.QUICK_CHARGE, 1);
            }
            var5.put(Enchantments.MULTISHOT, 1);
            EnchantmentManager.setEnchantments(var5, var4);
            this.setItemSlot(EnumItemSlot.MAINHAND, var4);
        }
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.PILLAGER_CELEBRATE;
    }
}

