/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityDrowned
extends EntityZombie
implements IRangedEntity {
    public static final float NAUTILUS_SHELL_CHANCE = 0.03f;
    boolean searchingForLand;
    public final NavigationGuardian waterNavigation;
    public final Navigation groundNavigation;

    public EntityDrowned(EntityTypes<? extends EntityDrowned> var0, World var1) {
        super((EntityTypes<? extends EntityZombie>)var0, var1);
        this.maxUpStep = 1.0f;
        this.moveControl = new d(this);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterNavigation = new NavigationGuardian(this, var1);
        this.groundNavigation = new Navigation(this, var1);
    }

    @Override
    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(1, new c(this, 1.0));
        this.goalSelector.addGoal(2, new f(this, 1.0, 40, 10.0f));
        this.goalSelector.addGoal(2, new a(this, 1.0, false));
        this.goalSelector.addGoal(5, new b(this, 1.0));
        this.goalSelector.addGoal(6, new e(this, 1.0, this.level.getSeaLevel()));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStroll(this, 1.0));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityDrowned.class).setAlertOthers(EntityPigZombie.class));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::okTarget));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<Axolotl>(this, Axolotl.class, true, false));
        this.targetSelector.addGoal(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        var3 = super.finalizeSpawn(var0, var1, var2, var3, var4);
        if (this.getItemBySlot(EnumItemSlot.OFFHAND).isEmpty() && this.random.nextFloat() < 0.03f) {
            this.setItemSlot(EnumItemSlot.OFFHAND, new ItemStack(Items.NAUTILUS_SHELL));
            this.handDropChances[EnumItemSlot.OFFHAND.getIndex()] = 2.0f;
        }
        return var3;
    }

    public static boolean checkDrownedSpawnRules(EntityTypes<EntityDrowned> var0, WorldAccess var1, EnumMobSpawn var2, BlockPosition var3, Random var4) {
        boolean var6;
        if (!var1.getFluidState(var3.below()).is(TagsFluid.WATER)) {
            return false;
        }
        Optional<ResourceKey<BiomeBase>> var5 = var1.getBiomeName(var3);
        boolean bl = var6 = var1.getDifficulty() != EnumDifficulty.PEACEFUL && EntityDrowned.isDarkEnoughToSpawn(var1, var3, var4) && (var2 == EnumMobSpawn.SPAWNER || var1.getFluidState(var3).is(TagsFluid.WATER));
        if (Objects.equals(var5, Optional.of(Biomes.RIVER)) || Objects.equals(var5, Optional.of(Biomes.FROZEN_RIVER))) {
            return var4.nextInt(15) == 0 && var6;
        }
        return var4.nextInt(40) == 0 && EntityDrowned.isDeepEnoughToSpawn(var1, var3) && var6;
    }

    private static boolean isDeepEnoughToSpawn(GeneratorAccess var0, BlockPosition var1) {
        return var1.getY() < var0.getSeaLevel() - 5;
    }

    @Override
    protected boolean supportsBreakDoorGoal() {
        return false;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isInWater()) {
            return SoundEffects.DROWNED_AMBIENT_WATER;
        }
        return SoundEffects.DROWNED_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.isInWater()) {
            return SoundEffects.DROWNED_HURT_WATER;
        }
        return SoundEffects.DROWNED_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        if (this.isInWater()) {
            return SoundEffects.DROWNED_DEATH_WATER;
        }
        return SoundEffects.DROWNED_DEATH;
    }

    @Override
    protected SoundEffect getStepSound() {
        return SoundEffects.DROWNED_STEP;
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.DROWNED_SWIM;
    }

    @Override
    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }

    @Override
    protected void populateDefaultEquipmentSlots(DifficultyDamageScaler var0) {
        if ((double)this.random.nextFloat() > 0.9) {
            int var1 = this.random.nextInt(16);
            if (var1 < 10) {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.TRIDENT));
            } else {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.FISHING_ROD));
            }
        }
    }

    @Override
    protected boolean canReplaceCurrentItem(ItemStack var0, ItemStack var1) {
        if (var1.is(Items.NAUTILUS_SHELL)) {
            return false;
        }
        if (var1.is(Items.TRIDENT)) {
            if (var0.is(Items.TRIDENT)) {
                return var0.getDamageValue() < var1.getDamageValue();
            }
            return false;
        }
        if (var0.is(Items.TRIDENT)) {
            return true;
        }
        return super.canReplaceCurrentItem(var0, var1);
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    public boolean okTarget(@Nullable EntityLiving var0) {
        if (var0 != null) {
            return !this.level.isDay() || var0.isInWater();
        }
        return false;
    }

    @Override
    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        EntityLiving var0 = this.getTarget();
        return var0 != null && var0.isInWater();
    }

    @Override
    public void travel(Vec3D var0) {
        if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
            this.moveRelative(0.01f, var0);
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(var0);
        }
    }

    @Override
    public void updateSwimming() {
        if (!this.level.isClientSide) {
            if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigation;
                this.setSwimming(false);
            }
        }
    }

    protected boolean closeToNextPos() {
        double var2;
        BlockPosition var1;
        PathEntity var0 = this.getNavigation().getPath();
        return var0 != null && (var1 = var0.getTarget()) != null && (var2 = this.distanceToSqr(var1.getX(), var1.getY(), var1.getZ())) < 4.0;
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        EntityThrownTrident var2 = new EntityThrownTrident(this.level, (EntityLiving)this, new ItemStack(Items.TRIDENT));
        double var3 = var0.getX() - this.getX();
        double var5 = var0.getY(0.3333333333333333) - var2.getY();
        double var7 = var0.getZ() - this.getZ();
        double var9 = Math.sqrt(var3 * var3 + var7 * var7);
        var2.shoot(var3, var5 + var9 * (double)0.2f, var7, 1.6f, 14 - this.level.getDifficulty().getId() * 4);
        this.playSound(SoundEffects.DROWNED_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level.addFreshEntity(var2);
    }

    public void setSearchingForLand(boolean var0) {
        this.searchingForLand = var0;
    }

    static class d
    extends ControllerMove {
        private final EntityDrowned drowned;

        public d(EntityDrowned var0) {
            super(var0);
            this.drowned = var0;
        }

        @Override
        public void tick() {
            EntityLiving var0 = this.drowned.getTarget();
            if (this.drowned.wantsToSwim() && this.drowned.isInWater()) {
                if (var0 != null && var0.getY() > this.drowned.getY() || this.drowned.searchingForLand) {
                    this.drowned.setDeltaMovement(this.drowned.getDeltaMovement().add(0.0, 0.002, 0.0));
                }
                if (this.operation != ControllerMove.Operation.MOVE_TO || this.drowned.getNavigation().isDone()) {
                    this.drowned.setSpeed(0.0f);
                    return;
                }
                double var1 = this.wantedX - this.drowned.getX();
                double var3 = this.wantedY - this.drowned.getY();
                double var5 = this.wantedZ - this.drowned.getZ();
                double var7 = Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5);
                var3 /= var7;
                float var9 = (float)(MathHelper.atan2(var5, var1) * 57.2957763671875) - 90.0f;
                this.drowned.setYRot(this.rotlerp(this.drowned.getYRot(), var9, 90.0f));
                this.drowned.yBodyRot = this.drowned.getYRot();
                float var10 = (float)(this.speedModifier * this.drowned.getAttributeValue(GenericAttributes.MOVEMENT_SPEED));
                float var11 = MathHelper.lerp(0.125f, this.drowned.getSpeed(), var10);
                this.drowned.setSpeed(var11);
                this.drowned.setDeltaMovement(this.drowned.getDeltaMovement().add((double)var11 * var1 * 0.005, (double)var11 * var3 * 0.1, (double)var11 * var5 * 0.005));
            } else {
                if (!this.drowned.onGround) {
                    this.drowned.setDeltaMovement(this.drowned.getDeltaMovement().add(0.0, -0.008, 0.0));
                }
                super.tick();
            }
        }
    }

    static class c
    extends PathfinderGoal {
        private final EntityCreature mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final World level;

        public c(EntityCreature var0, double var1) {
            this.mob = var0;
            this.speedModifier = var1;
            this.level = var0.level;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            if (!this.level.isDay()) {
                return false;
            }
            if (this.mob.isInWater()) {
                return false;
            }
            Vec3D var0 = this.getWaterPos();
            if (var0 == null) {
                return false;
            }
            this.wantedX = var0.x;
            this.wantedY = var0.y;
            this.wantedZ = var0.z;
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            return !this.mob.getNavigation().isDone();
        }

        @Override
        public void start() {
            this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3D getWaterPos() {
            Random var0 = this.mob.getRandom();
            BlockPosition var1 = this.mob.blockPosition();
            for (int var2 = 0; var2 < 10; ++var2) {
                BlockPosition var3 = var1.offset(var0.nextInt(20) - 10, 2 - var0.nextInt(8), var0.nextInt(20) - 10);
                if (!this.level.getBlockState(var3).is(Blocks.WATER)) continue;
                return Vec3D.atBottomCenterOf(var3);
            }
            return null;
        }
    }

    static class f
    extends PathfinderGoalArrowAttack {
        private final EntityDrowned drowned;

        public f(IRangedEntity var0, double var1, int var3, float var4) {
            super(var0, var1, var3, var4);
            this.drowned = (EntityDrowned)var0;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.drowned.getMainHandItem().is(Items.TRIDENT);
        }

        @Override
        public void start() {
            super.start();
            this.drowned.setAggressive(true);
            this.drowned.startUsingItem(EnumHand.MAIN_HAND);
        }

        @Override
        public void stop() {
            super.stop();
            this.drowned.stopUsingItem();
            this.drowned.setAggressive(false);
        }
    }

    static class a
    extends PathfinderGoalZombieAttack {
        private final EntityDrowned drowned;

        public a(EntityDrowned var0, double var1, boolean var3) {
            super(var0, var1, var3);
            this.drowned = var0;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.drowned.okTarget(this.drowned.getTarget());
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.drowned.okTarget(this.drowned.getTarget());
        }
    }

    static class b
    extends PathfinderGoalGotoTarget {
        private final EntityDrowned drowned;

        public b(EntityDrowned var0, double var1) {
            super(var0, var1, 8, 2);
            this.drowned = var0;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !this.drowned.level.isDay() && this.drowned.isInWater() && this.drowned.getY() >= (double)(this.drowned.level.getSeaLevel() - 3);
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse();
        }

        @Override
        protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
            BlockPosition var2 = var1.above();
            if (!var0.isEmptyBlock(var2) || !var0.isEmptyBlock(var2.above())) {
                return false;
            }
            return var0.getBlockState(var1).entityCanStandOn(var0, var1, this.drowned);
        }

        @Override
        public void start() {
            this.drowned.setSearchingForLand(false);
            this.drowned.navigation = this.drowned.groundNavigation;
            super.start();
        }

        @Override
        public void stop() {
            super.stop();
        }
    }

    static class e
    extends PathfinderGoal {
        private final EntityDrowned drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public e(EntityDrowned var0, double var1, int var3) {
            this.drowned = var0;
            this.speedModifier = var1;
            this.seaLevel = var3;
        }

        @Override
        public boolean canUse() {
            return !this.drowned.level.isDay() && this.drowned.isInWater() && this.drowned.getY() < (double)(this.seaLevel - 2);
        }

        @Override
        public boolean canContinueToUse() {
            return this.canUse() && !this.stuck;
        }

        @Override
        public void tick() {
            if (this.drowned.getY() < (double)(this.seaLevel - 1) && (this.drowned.getNavigation().isDone() || this.drowned.closeToNextPos())) {
                Vec3D var0 = DefaultRandomPos.getPosTowards(this.drowned, 4, 8, new Vec3D(this.drowned.getX(), this.seaLevel - 1, this.drowned.getZ()), 1.5707963705062866);
                if (var0 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.getNavigation().moveTo(var0.x, var0.y, var0.z, this.speedModifier);
            }
        }

        @Override
        public void start() {
            this.drowned.setSearchingForLand(true);
            this.stuck = false;
        }

        @Override
        public void stop() {
            this.drowned.setSearchingForLand(false);
        }
    }
}

