/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class EntityItem
extends Entity {
    private static final DataWatcherObject<ItemStack> DATA_ITEM = DataWatcher.defineId(EntityItem.class, DataWatcherRegistry.ITEM_STACK);
    private static final int LIFETIME = 6000;
    private static final int INFINITE_PICKUP_DELAY = Short.MAX_VALUE;
    private static final int INFINITE_LIFETIME = Short.MIN_VALUE;
    public int age;
    public int pickupDelay;
    private int health = 5;
    @Nullable
    private UUID thrower;
    @Nullable
    private UUID owner;
    public final float bobOffs;

    public EntityItem(EntityTypes<? extends EntityItem> var0, World var1) {
        super(var0, var1);
        this.bobOffs = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.setYRot(this.random.nextFloat() * 360.0f);
    }

    public EntityItem(World var0, double var1, double var3, double var5, ItemStack var7) {
        this(var0, var1, var3, var5, var7, var0.random.nextDouble() * 0.2 - 0.1, 0.2, var0.random.nextDouble() * 0.2 - 0.1);
    }

    public EntityItem(World var0, double var1, double var3, double var5, ItemStack var7, double var8, double var10, double var12) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ITEM, var0);
        this.setPos(var1, var3, var5);
        this.setDeltaMovement(var8, var10, var12);
        this.setItem(var7);
    }

    private EntityItem(EntityItem var0) {
        super(var0.getType(), var0.level);
        this.setItem(var0.getItem().copy());
        this.copyPosition(var0);
        this.age = var0.age;
        this.bobOffs = var0.bobOffs;
    }

    @Override
    public boolean occludesVibrations() {
        return TagsItem.OCCLUDES_VIBRATION_SIGNALS.contains(this.getItem().getItem());
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData() {
        this.getEntityData().define(DATA_ITEM, ItemStack.EMPTY);
    }

    @Override
    public void tick() {
        double var4;
        int var3;
        if (this.getItem().isEmpty()) {
            this.discard();
            return;
        }
        super.tick();
        if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
            --this.pickupDelay;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        Vec3D var0 = this.getDeltaMovement();
        float var1 = this.getEyeHeight() - 0.11111111f;
        if (this.isInWater() && this.getFluidHeight(TagsFluid.WATER) > (double)var1) {
            this.setUnderwaterMovement();
        } else if (this.isInLava() && this.getFluidHeight(TagsFluid.LAVA) > (double)var1) {
            this.setUnderLavaMovement();
        } else if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        if (this.level.isClientSide) {
            this.noPhysics = false;
        } else {
            boolean bl = this.noPhysics = !this.level.noCollision(this, this.getBoundingBox().deflate(1.0E-7));
            if (this.noPhysics) {
                this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
            }
        }
        if (!this.onGround || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            float var2 = 0.98f;
            if (this.onGround) {
                var2 = this.level.getBlockState(new BlockPosition(this.getX(), this.getY() - 1.0, this.getZ())).getBlock().getFriction() * 0.98f;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(var2, 0.98, var2));
            if (this.onGround) {
                Vec3D var32 = this.getDeltaMovement();
                if (var32.y < 0.0) {
                    this.setDeltaMovement(var32.multiply(1.0, -0.5, 1.0));
                }
            }
        }
        boolean var2 = MathHelper.floor(this.xo) != MathHelper.floor(this.getX()) || MathHelper.floor(this.yo) != MathHelper.floor(this.getY()) || MathHelper.floor(this.zo) != MathHelper.floor(this.getZ());
        int n2 = var3 = var2 ? 2 : 40;
        if (this.tickCount % var3 == 0 && !this.level.isClientSide && this.isMergable()) {
            this.mergeWithNeighbours();
        }
        if (this.age != Short.MIN_VALUE) {
            ++this.age;
        }
        this.hasImpulse |= this.updateInWaterStateAndDoFluidPushing();
        if (!this.level.isClientSide && (var4 = this.getDeltaMovement().subtract(var0).lengthSqr()) > 0.01) {
            this.hasImpulse = true;
        }
        if (!this.level.isClientSide && this.age >= 6000) {
            this.discard();
        }
    }

    private void setUnderwaterMovement() {
        Vec3D var0 = this.getDeltaMovement();
        this.setDeltaMovement(var0.x * (double)0.99f, var0.y + (double)(var0.y < (double)0.06f ? 5.0E-4f : 0.0f), var0.z * (double)0.99f);
    }

    private void setUnderLavaMovement() {
        Vec3D var0 = this.getDeltaMovement();
        this.setDeltaMovement(var0.x * (double)0.95f, var0.y + (double)(var0.y < (double)0.06f ? 5.0E-4f : 0.0f), var0.z * (double)0.95f);
    }

    private void mergeWithNeighbours() {
        if (!this.isMergable()) {
            return;
        }
        List<EntityItem> var02 = this.level.getEntitiesOfClass(EntityItem.class, this.getBoundingBox().inflate(0.5, 0.0, 0.5), var0 -> var0 != this && var0.isMergable());
        for (EntityItem var2 : var02) {
            if (!var2.isMergable()) continue;
            this.tryToMerge(var2);
            if (!this.isRemoved()) continue;
            break;
        }
    }

    private boolean isMergable() {
        ItemStack var0 = this.getItem();
        return this.isAlive() && this.pickupDelay != Short.MAX_VALUE && this.age != Short.MIN_VALUE && this.age < 6000 && var0.getCount() < var0.getMaxStackSize();
    }

    private void tryToMerge(EntityItem var0) {
        ItemStack var1 = this.getItem();
        ItemStack var2 = var0.getItem();
        if (!Objects.equals(this.getOwner(), var0.getOwner()) || !EntityItem.areMergable(var1, var2)) {
            return;
        }
        if (var2.getCount() < var1.getCount()) {
            EntityItem.merge(this, var1, var0, var2);
        } else {
            EntityItem.merge(var0, var2, this, var1);
        }
    }

    public static boolean areMergable(ItemStack var0, ItemStack var1) {
        if (!var1.is(var0.getItem())) {
            return false;
        }
        if (var1.getCount() + var0.getCount() > var1.getMaxStackSize()) {
            return false;
        }
        if (var1.hasTag() ^ var0.hasTag()) {
            return false;
        }
        return !var1.hasTag() || var1.getTag().equals(var0.getTag());
    }

    public static ItemStack merge(ItemStack var0, ItemStack var1, int var2) {
        int var3 = Math.min(Math.min(var0.getMaxStackSize(), var2) - var0.getCount(), var1.getCount());
        ItemStack var4 = var0.copy();
        var4.grow(var3);
        var1.shrink(var3);
        return var4;
    }

    private static void merge(EntityItem var0, ItemStack var1, ItemStack var2) {
        ItemStack var3 = EntityItem.merge(var1, var2, 64);
        var0.setItem(var3);
    }

    private static void merge(EntityItem var0, ItemStack var1, EntityItem var2, ItemStack var3) {
        EntityItem.merge(var0, var1, var3);
        var0.pickupDelay = Math.max(var0.pickupDelay, var2.pickupDelay);
        var0.age = Math.min(var0.age, var2.age);
        if (var3.isEmpty()) {
            var2.discard();
        }
    }

    @Override
    public boolean fireImmune() {
        return this.getItem().getItem().isFireResistant() || super.fireImmune();
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        if (!this.getItem().isEmpty() && this.getItem().is(Items.NETHER_STAR) && var0.isExplosion()) {
            return false;
        }
        if (!this.getItem().getItem().canBeHurtBy(var0)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - var1);
        this.gameEvent(GameEvent.ENTITY_DAMAGED, var0.getEntity());
        if (this.health <= 0) {
            this.getItem().onDestroyed(this);
            this.discard();
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putShort("Health", (short)this.health);
        var0.putShort("Age", (short)this.age);
        var0.putShort("PickupDelay", (short)this.pickupDelay);
        if (this.getThrower() != null) {
            var0.putUUID("Thrower", this.getThrower());
        }
        if (this.getOwner() != null) {
            var0.putUUID("Owner", this.getOwner());
        }
        if (!this.getItem().isEmpty()) {
            var0.put("Item", this.getItem().save(new NBTTagCompound()));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        this.health = var0.getShort("Health");
        this.age = var0.getShort("Age");
        if (var0.contains("PickupDelay")) {
            this.pickupDelay = var0.getShort("PickupDelay");
        }
        if (var0.hasUUID("Owner")) {
            this.owner = var0.getUUID("Owner");
        }
        if (var0.hasUUID("Thrower")) {
            this.thrower = var0.getUUID("Thrower");
        }
        NBTTagCompound var1 = var0.getCompound("Item");
        this.setItem(ItemStack.of(var1));
        if (this.getItem().isEmpty()) {
            this.discard();
        }
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (this.level.isClientSide) {
            return;
        }
        ItemStack var1 = this.getItem();
        Item var2 = var1.getItem();
        int var3 = var1.getCount();
        if (this.pickupDelay == 0 && (this.owner == null || this.owner.equals(var0.getUUID())) && var0.getInventory().add(var1)) {
            var0.take(this, var3);
            if (var1.isEmpty()) {
                this.discard();
                var1.setCount(var3);
            }
            var0.awardStat(StatisticList.ITEM_PICKED_UP.get(var2), var3);
            var0.onItemPickup(this);
        }
    }

    @Override
    public IChatBaseComponent getName() {
        IChatBaseComponent var0 = this.getCustomName();
        if (var0 != null) {
            return var0;
        }
        return new ChatMessage(this.getItem().getDescriptionId());
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    @Nullable
    public Entity changeDimension(WorldServer var0) {
        Entity var1 = super.changeDimension(var0);
        if (!this.level.isClientSide && var1 instanceof EntityItem) {
            ((EntityItem)var1).mergeWithNeighbours();
        }
        return var1;
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack var0) {
        this.getEntityData().set(DATA_ITEM, var0);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_ITEM.equals(var0)) {
            this.getItem().setEntityRepresentation(this);
        }
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID var0) {
        this.owner = var0;
    }

    @Nullable
    public UUID getThrower() {
        return this.thrower;
    }

    public void setThrower(@Nullable UUID var0) {
        this.thrower = var0;
    }

    public int getAge() {
        return this.age;
    }

    public void setDefaultPickUpDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickUpDelay() {
        this.pickupDelay = 0;
    }

    public void setNeverPickUp() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickUpDelay(int var0) {
        this.pickupDelay = var0;
    }

    public boolean hasPickUpDelay() {
        return this.pickupDelay > 0;
    }

    public void setUnlimitedLifetime() {
        this.age = Short.MIN_VALUE;
    }

    public void setExtendedLifetime() {
        this.age = -6000;
    }

    public void makeFakeItem() {
        this.setNeverPickUp();
        this.age = 5999;
    }

    public float getSpin(float var0) {
        return ((float)this.getAge() + var0) / 20.0f + this.bobOffs;
    }

    @Override
    public Packet<?> getAddEntityPacket() {
        return new PacketPlayOutSpawnEntity(this);
    }

    public EntityItem copy() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.AMBIENT;
    }
}

