/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonController;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;

public class DragonControllerFly
extends AbstractDragonController {
    private boolean firstTick;
    @Nullable
    private PathEntity currentPath;
    @Nullable
    private Vec3D targetLocation;

    public DragonControllerFly(EntityEnderDragon var0) {
        super(var0);
    }

    @Override
    public void doServerTick() {
        if (this.firstTick || this.currentPath == null) {
            this.firstTick = false;
            this.findNewTarget();
        } else {
            BlockPosition var0 = this.dragon.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.END_PODIUM_LOCATION);
            if (!var0.closerThan(this.dragon.position(), 10.0)) {
                this.dragon.getPhaseManager().setPhase(DragonControllerPhase.HOLDING_PATTERN);
            }
        }
    }

    @Override
    public void begin() {
        this.firstTick = true;
        this.currentPath = null;
        this.targetLocation = null;
    }

    private void findNewTarget() {
        int var0 = this.dragon.findClosestNode();
        Vec3D var1 = this.dragon.getHeadLookVector(1.0f);
        int var2 = this.dragon.findClosestNode(-var1.x * 40.0, 105.0, -var1.z * 40.0);
        if (this.dragon.getDragonFight() == null || this.dragon.getDragonFight().getCrystalsAlive() <= 0) {
            var2 -= 12;
            var2 &= 7;
            var2 += 12;
        } else if ((var2 %= 12) < 0) {
            var2 += 12;
        }
        this.currentPath = this.dragon.findPath(var0, var2, null);
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null) {
            this.currentPath.advance();
            if (!this.currentPath.isDone()) {
                double var1;
                BlockPosition var0 = this.currentPath.getNextNodePos();
                this.currentPath.advance();
                while ((var1 = (double)((float)var0.getY() + this.dragon.getRandom().nextFloat() * 20.0f)) < (double)var0.getY()) {
                }
                this.targetLocation = new Vec3D(var0.getX(), var1, var0.getZ());
            }
        }
    }

    @Override
    @Nullable
    public Vec3D getFlyTargetLocation() {
        return this.targetLocation;
    }

    public DragonControllerPhase<DragonControllerFly> getPhase() {
        return DragonControllerPhase.TAKEOFF;
    }
}

