/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public class EntityHorseZombie
extends EntityHorseAbstract {
    public EntityHorseZombie(EntityTypes<? extends EntityHorseZombie> var0, World var1) {
        super((EntityTypes<? extends EntityHorseAbstract>)var0, var1);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityHorseZombie.createBaseHorseAttributes().add(GenericAttributes.MAX_HEALTH, 15.0).add(GenericAttributes.MOVEMENT_SPEED, 0.2f);
    }

    @Override
    protected void randomizeAttributes() {
        this.getAttribute(GenericAttributes.JUMP_STRENGTH).setBaseValue(this.generateRandomJumpStrength());
    }

    @Override
    public EnumMonsterType getMobType() {
        return EnumMonsterType.UNDEAD;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        super.getAmbientSound();
        return SoundEffects.ZOMBIE_HORSE_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        super.getDeathSound();
        return SoundEffects.ZOMBIE_HORSE_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        super.getHurtSound(var0);
        return SoundEffects.ZOMBIE_HORSE_HURT;
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.ZOMBIE_HORSE.create(var0);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (!this.isTamed()) {
            return EnumInteractionResult.PASS;
        }
        if (this.isBaby()) {
            return super.mobInteract(var0, var1);
        }
        if (var0.isSecondaryUseActive()) {
            this.openInventory(var0);
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        if (this.isVehicle()) {
            return super.mobInteract(var0, var1);
        }
        if (!var2.isEmpty()) {
            if (var2.is(Items.SADDLE) && !this.isSaddled()) {
                this.openInventory(var0);
                return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
            }
            EnumInteractionResult var3 = var2.interactLivingEntity(var0, this, var1);
            if (var3.consumesAction()) {
                return var3;
            }
        }
        this.doPlayerRide(var0);
        return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
    }

    @Override
    protected void addBehaviourGoals() {
    }
}

