/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> DATA_INTERESTED_ID = DataWatcher.defineId(EntityWolf.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_COLLAR_COLOR = DataWatcher.defineId(EntityWolf.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_REMAINING_ANGER_TIME = DataWatcher.defineId(EntityWolf.class, DataWatcherRegistry.INT);
    public static final Predicate<EntityLiving> PREY_SELECTOR = var0 -> {
        EntityTypes<?> var1 = var0.getType();
        return var1 == EntityTypes.SHEEP || var1 == EntityTypes.RABBIT || var1 == EntityTypes.FOX;
    };
    private static final float START_HEALTH = 8.0f;
    private static final float TAME_HEALTH = 20.0f;
    private float interestedAngle;
    private float interestedAngleO;
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeRange.rangeOfSeconds(20, 39);
    @Nullable
    private UUID persistentAngerTarget;

    public EntityWolf(EntityTypes<? extends EntityWolf> var0, World var1) {
        super((EntityTypes<? extends EntityTameableAnimal>)var0, var1);
        this.setTame(false);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(2, new PathfinderGoalSit(this));
        this.goalSelector.addGoal(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.goalSelector.addGoal(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.goalSelector.addGoal(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f, false));
        this.goalSelector.addGoal(7, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(9, new PathfinderGoalBeg(this, 8.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.targetSelector.addGoal(2, new PathfinderGoalOwnerHurtTarget(this));
        this.targetSelector.addGoal(3, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.targetSelector.addGoal(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.MAX_HEALTH, 8.0).add(GenericAttributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_INTERESTED_ID, false);
        this.entityData.define(DATA_COLLAR_COLOR, EnumColor.RED.getId());
        this.entityData.define(DATA_REMAINING_ANGER_TIME, 0);
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.WOLF_STEP, 0.15f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putByte("CollarColor", (byte)this.getCollarColor().getId());
        this.addPersistentAngerSaveData(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("CollarColor", 99)) {
            this.setCollarColor(EnumColor.byId(var0.getInt("CollarColor")));
        }
        this.readPersistentAngerSaveData(this.level, var0);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isAngry()) {
            return SoundEffects.WOLF_GROWL;
        }
        if (this.random.nextInt(3) == 0) {
            if (this.isTame() && this.getHealth() < 10.0f) {
                return SoundEffects.WOLF_WHINE;
            }
            return SoundEffects.WOLF_PANT;
        }
        return SoundEffects.WOLF_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.WOLF_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WOLF_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level.isClientSide && this.isWet && !this.isShaking && !this.isPathFinding() && this.onGround) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.level.broadcastEntityEvent(this, (byte)8);
        }
        if (!this.level.isClientSide) {
            this.updatePersistentAnger((WorldServer)this.level, true);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isAlive()) {
            return;
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        if (this.isInWaterRainOrBubble()) {
            this.isWet = true;
            if (this.isShaking && !this.level.isClientSide) {
                this.level.broadcastEntityEvent(this, (byte)56);
                this.cancelShake();
            }
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.shakeAnim == 0.0f) {
                this.playSound(SoundEffects.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.gameEvent(GameEvent.WOLF_SHAKING);
            }
            this.shakeAnimO = this.shakeAnim;
            this.shakeAnim += 0.05f;
            if (this.shakeAnimO >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.shakeAnimO = 0.0f;
                this.shakeAnim = 0.0f;
            }
            if (this.shakeAnim > 0.4f) {
                float var0 = (float)this.getY();
                int var1 = (int)(MathHelper.sin((this.shakeAnim - 0.4f) * (float)Math.PI) * 7.0f);
                Vec3D var2 = this.getDeltaMovement();
                for (int var3 = 0; var3 < var1; ++var3) {
                    float var4 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                    float var5 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                    this.level.addParticle(Particles.SPLASH, this.getX() + (double)var4, var0 + 0.8f, this.getZ() + (double)var5, var2.x, var2.y, var2.z);
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    @Override
    public void die(DamageSource var0) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.die(var0);
    }

    public boolean isWet() {
        return this.isWet;
    }

    public float getWetShade(float var0) {
        return Math.min(0.5f + MathHelper.lerp(var0, this.shakeAnimO, this.shakeAnim) / 2.0f * 0.5f, 1.0f);
    }

    public float getBodyRollAngle(float var0, float var1) {
        float var2 = (MathHelper.lerp(var0, this.shakeAnimO, this.shakeAnim) + var1) / 1.8f;
        if (var2 < 0.0f) {
            var2 = 0.0f;
        } else if (var2 > 1.0f) {
            var2 = 1.0f;
        }
        return MathHelper.sin(var2 * (float)Math.PI) * MathHelper.sin(var2 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float getHeadRollAngle(float var0) {
        return MathHelper.lerp(var0, this.interestedAngleO, this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height * 0.8f;
    }

    @Override
    public int getMaxHeadXRot() {
        if (this.isInSittingPose()) {
            return 20;
        }
        return super.getMaxHeadXRot();
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        Entity var2 = var0.getEntity();
        this.setOrderedToSit(false);
        if (var2 != null && !(var2 instanceof EntityHuman) && !(var2 instanceof EntityArrow)) {
            var1 = (var1 + 1.0f) / 2.0f;
        }
        return super.hurt(var0, var1);
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        boolean var1 = var0.hurt(DamageSource.mobAttack(this), (int)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE));
        if (var1) {
            this.doEnchantDamageEffects(this, var0);
        }
        return var1;
    }

    @Override
    public void setTame(boolean var0) {
        super.setTame(var0);
        if (var0) {
            this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(20.0);
            this.setHealth(20.0f);
        } else {
            this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(8.0);
        }
        this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        Item var3 = var2.getItem();
        if (this.level.isClientSide) {
            boolean var4 = this.isOwnedBy(var0) || this.isTame() || var2.is(Items.BONE) && !this.isTame() && !this.isAngry();
            return var4 ? EnumInteractionResult.CONSUME : EnumInteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isFood(var2) && this.getHealth() < this.getMaxHealth()) {
                if (!var0.getAbilities().instabuild) {
                    var2.shrink(1);
                }
                this.heal(var3.getFoodProperties().getNutrition());
                this.gameEvent(GameEvent.MOB_INTERACT, this.eyeBlockPosition());
                return EnumInteractionResult.SUCCESS;
            }
            if (var3 instanceof ItemDye) {
                EnumColor var4 = ((ItemDye)var3).getDyeColor();
                if (var4 == this.getCollarColor()) return super.mobInteract(var0, var1);
                this.setCollarColor(var4);
                if (var0.getAbilities().instabuild) return EnumInteractionResult.SUCCESS;
                var2.shrink(1);
                return EnumInteractionResult.SUCCESS;
            }
            EnumInteractionResult var4 = super.mobInteract(var0, var1);
            if (var4.consumesAction() && !this.isBaby() || !this.isOwnedBy(var0)) return var4;
            this.setOrderedToSit(!this.isOrderedToSit());
            this.jumping = false;
            this.navigation.stop();
            this.setTarget(null);
            return EnumInteractionResult.SUCCESS;
        }
        if (!var2.is(Items.BONE) || this.isAngry()) return super.mobInteract(var0, var1);
        if (!var0.getAbilities().instabuild) {
            var2.shrink(1);
        }
        if (this.random.nextInt(3) == 0) {
            this.tame(var0);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level.broadcastEntityEvent(this, (byte)7);
            return EnumInteractionResult.SUCCESS;
        } else {
            this.level.broadcastEntityEvent(this, (byte)6);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (var0 == 56) {
            this.cancelShake();
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (this.isTame()) {
            return (0.55f - (this.getMaxHealth() - this.getHealth()) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        Item var1 = var0.getItem();
        return var1.isEdible() && var1.getFoodProperties().isMeat();
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 8;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void setRemainingPersistentAngerTime(int var0) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, var0);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID var0) {
        this.persistentAngerTarget = var0;
    }

    public EnumColor getCollarColor() {
        return EnumColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    public void setCollarColor(EnumColor var0) {
        this.entityData.set(DATA_COLLAR_COLOR, var0.getId());
    }

    @Override
    public EntityWolf getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityWolf var2 = EntityTypes.WOLF.create(var0);
        UUID var3 = this.getOwnerUUID();
        if (var3 != null) {
            var2.setOwnerUUID(var3);
            var2.setTame(true);
        }
        return var2;
    }

    public void setIsInterested(boolean var0) {
        this.entityData.set(DATA_INTERESTED_ID, var0);
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(var0 instanceof EntityWolf)) {
            return false;
        }
        EntityWolf var1 = (EntityWolf)var0;
        if (!var1.isTame()) {
            return false;
        }
        if (var1.isInSittingPose()) {
            return false;
        }
        return this.isInLove() && var1.isInLove();
    }

    public boolean isInterested() {
        return this.entityData.get(DATA_INTERESTED_ID);
    }

    @Override
    public boolean wantsToAttack(EntityLiving var0, EntityLiving var1) {
        if (var0 instanceof EntityCreeper || var0 instanceof EntityGhast) {
            return false;
        }
        if (var0 instanceof EntityWolf) {
            EntityWolf var2 = (EntityWolf)var0;
            return !var2.isTame() || var2.getOwner() != var1;
        }
        if (var0 instanceof EntityHuman && var1 instanceof EntityHuman && !((EntityHuman)var1).canHarmPlayer((EntityHuman)var0)) {
            return false;
        }
        if (var0 instanceof EntityHorseAbstract && ((EntityHorseAbstract)var0).isTamed()) {
            return false;
        }
        return !(var0 instanceof EntityTameableAnimal) || !((EntityTameableAnimal)var0).isTame();
    }

    @Override
    public boolean canBeLeashed(EntityHuman var0) {
        return !this.isAngry() && super.canBeLeashed(var0);
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public static boolean checkWolfSpawnRules(EntityTypes<EntityWolf> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, Random var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.WOLVES_SPAWNABLE_ON) && EntityWolf.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf wolf;

        public a(EntityWolf var1, Class var2, float var3, double var4, double var6) {
            super(var1, var2, var3, var4, var6);
            this.wolf = var1;
        }

        @Override
        public boolean canUse() {
            if (super.canUse() && this.toAvoid instanceof EntityLlama) {
                return !this.wolf.isTame() && this.avoidLlama((EntityLlama)this.toAvoid);
            }
            return false;
        }

        private boolean avoidLlama(EntityLlama var0) {
            return var0.getStrength() >= EntityWolf.this.random.nextInt(5);
        }

        @Override
        public void start() {
            EntityWolf.this.setTarget(null);
            super.start();
        }

        @Override
        public void tick() {
            EntityWolf.this.setTarget(null);
            super.tick();
        }
    }
}

