/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityParrot
extends EntityPerchable
implements EntityBird {
    private static final DataWatcherObject<Integer> DATA_VARIANT_ID = DataWatcher.defineId(EntityParrot.class, DataWatcherRegistry.INT);
    private static final Predicate<EntityInsentient> NOT_PARROT_PREDICATE = new Predicate<EntityInsentient>(){

        @Override
        public boolean test(@Nullable EntityInsentient var0) {
            return var0 != null && MOB_SOUND_MAP.containsKey(var0.getType());
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((EntityInsentient)object);
        }
    };
    private static final Item POISONOUS_FOOD = Items.COOKIE;
    private static final Set<Item> TAME_FOOD = Sets.newHashSet((Object[])new Item[]{Items.WHEAT_SEEDS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS, Items.BEETROOT_SEEDS});
    private static final int VARIANTS = 5;
    static final Map<EntityTypes<?>, SoundEffect> MOB_SOUND_MAP = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(EntityTypes.BLAZE, SoundEffects.PARROT_IMITATE_BLAZE);
        var0.put(EntityTypes.CAVE_SPIDER, SoundEffects.PARROT_IMITATE_SPIDER);
        var0.put(EntityTypes.CREEPER, SoundEffects.PARROT_IMITATE_CREEPER);
        var0.put(EntityTypes.DROWNED, SoundEffects.PARROT_IMITATE_DROWNED);
        var0.put(EntityTypes.ELDER_GUARDIAN, SoundEffects.PARROT_IMITATE_ELDER_GUARDIAN);
        var0.put(EntityTypes.ENDER_DRAGON, SoundEffects.PARROT_IMITATE_ENDER_DRAGON);
        var0.put(EntityTypes.ENDERMITE, SoundEffects.PARROT_IMITATE_ENDERMITE);
        var0.put(EntityTypes.EVOKER, SoundEffects.PARROT_IMITATE_EVOKER);
        var0.put(EntityTypes.GHAST, SoundEffects.PARROT_IMITATE_GHAST);
        var0.put(EntityTypes.GUARDIAN, SoundEffects.PARROT_IMITATE_GUARDIAN);
        var0.put(EntityTypes.HOGLIN, SoundEffects.PARROT_IMITATE_HOGLIN);
        var0.put(EntityTypes.HUSK, SoundEffects.PARROT_IMITATE_HUSK);
        var0.put(EntityTypes.ILLUSIONER, SoundEffects.PARROT_IMITATE_ILLUSIONER);
        var0.put(EntityTypes.MAGMA_CUBE, SoundEffects.PARROT_IMITATE_MAGMA_CUBE);
        var0.put(EntityTypes.PHANTOM, SoundEffects.PARROT_IMITATE_PHANTOM);
        var0.put(EntityTypes.PIGLIN, SoundEffects.PARROT_IMITATE_PIGLIN);
        var0.put(EntityTypes.PIGLIN_BRUTE, SoundEffects.PARROT_IMITATE_PIGLIN_BRUTE);
        var0.put(EntityTypes.PILLAGER, SoundEffects.PARROT_IMITATE_PILLAGER);
        var0.put(EntityTypes.RAVAGER, SoundEffects.PARROT_IMITATE_RAVAGER);
        var0.put(EntityTypes.SHULKER, SoundEffects.PARROT_IMITATE_SHULKER);
        var0.put(EntityTypes.SILVERFISH, SoundEffects.PARROT_IMITATE_SILVERFISH);
        var0.put(EntityTypes.SKELETON, SoundEffects.PARROT_IMITATE_SKELETON);
        var0.put(EntityTypes.SLIME, SoundEffects.PARROT_IMITATE_SLIME);
        var0.put(EntityTypes.SPIDER, SoundEffects.PARROT_IMITATE_SPIDER);
        var0.put(EntityTypes.STRAY, SoundEffects.PARROT_IMITATE_STRAY);
        var0.put(EntityTypes.VEX, SoundEffects.PARROT_IMITATE_VEX);
        var0.put(EntityTypes.VINDICATOR, SoundEffects.PARROT_IMITATE_VINDICATOR);
        var0.put(EntityTypes.WITCH, SoundEffects.PARROT_IMITATE_WITCH);
        var0.put(EntityTypes.WITHER, SoundEffects.PARROT_IMITATE_WITHER);
        var0.put(EntityTypes.WITHER_SKELETON, SoundEffects.PARROT_IMITATE_WITHER_SKELETON);
        var0.put(EntityTypes.ZOGLIN, SoundEffects.PARROT_IMITATE_ZOGLIN);
        var0.put(EntityTypes.ZOMBIE, SoundEffects.PARROT_IMITATE_ZOMBIE);
        var0.put(EntityTypes.ZOMBIE_VILLAGER, SoundEffects.PARROT_IMITATE_ZOMBIE_VILLAGER);
    });
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;
    private boolean partyParrot;
    @Nullable
    private BlockPosition jukebox;

    public EntityParrot(EntityTypes<? extends EntityParrot> var0, World var1) {
        super((EntityTypes<? extends EntityPerchable>)var0, var1);
        this.moveControl = new ControllerMoveFlying(this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        this.setVariant(this.random.nextInt(5));
        if (var3 == null) {
            var3 = new EntityAgeable.a(false);
        }
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    @Override
    public boolean isBaby() {
        return false;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalPanic(this, 1.25));
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(2, new PathfinderGoalSit(this));
        this.goalSelector.addGoal(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f, true));
        this.goalSelector.addGoal(2, new a(this, 1.0));
        this.goalSelector.addGoal(3, new PathfinderGoalPerch(this));
        this.goalSelector.addGoal(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 6.0).add(GenericAttributes.FLYING_SPEED, 0.4f).add(GenericAttributes.MOVEMENT_SPEED, 0.2f);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        NavigationFlying var1 = new NavigationFlying(this, var0);
        var1.setCanOpenDoors(false);
        var1.setCanFloat(true);
        var1.setCanPassDoors(true);
        return var1;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return var1.height * 0.6f;
    }

    @Override
    public void aiStep() {
        if (this.jukebox == null || !this.jukebox.closerThan(this.position(), 3.46) || !this.level.getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.partyParrot = false;
            this.jukebox = null;
        }
        if (this.level.random.nextInt(400) == 0) {
            EntityParrot.imitateNearbyMobs(this.level, this);
        }
        super.aiStep();
        this.calculateFlapping();
    }

    @Override
    public void setRecordPlayingNearby(BlockPosition var0, boolean var1) {
        this.jukebox = var0;
        this.partyParrot = var1;
    }

    public boolean isPartyParrot() {
        return this.partyParrot;
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.onGround || this.isPassenger() ? -1 : 4) * 0.3);
        this.flapSpeed = MathHelper.clamp(this.flapSpeed, 0.0f, 1.0f);
        if (!this.onGround && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3D var0 = this.getDeltaMovement();
        if (!this.onGround && var0.y < 0.0) {
            this.setDeltaMovement(var0.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public static boolean imitateNearbyMobs(World var0, Entity var1) {
        EntityInsentient var3;
        if (!var1.isAlive() || var1.isSilent() || var0.random.nextInt(2) != 0) {
            return false;
        }
        List<EntityInsentient> var2 = var0.getEntitiesOfClass(EntityInsentient.class, var1.getBoundingBox().inflate(20.0), NOT_PARROT_PREDICATE);
        if (!var2.isEmpty() && !(var3 = var2.get(var0.random.nextInt(var2.size()))).isSilent()) {
            SoundEffect var4 = EntityParrot.getImitatedSound(var3.getType());
            var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), var4, var1.getSoundSource(), 0.7f, EntityParrot.getPitch(var0.random));
            return true;
        }
        return false;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (!this.isTame() && TAME_FOOD.contains(var2.getItem())) {
            if (!var0.getAbilities().instabuild) {
                var2.shrink(1);
            }
            if (!this.isSilent()) {
                this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PARROT_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            if (!this.level.isClientSide) {
                if (this.random.nextInt(10) == 0) {
                    this.tame(var0);
                    this.level.broadcastEntityEvent(this, (byte)7);
                } else {
                    this.level.broadcastEntityEvent(this, (byte)6);
                }
            }
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        if (var2.is(POISONOUS_FOOD)) {
            if (!var0.getAbilities().instabuild) {
                var2.shrink(1);
            }
            this.addEffect(new MobEffect(MobEffects.POISON, 900));
            if (var0.isCreative() || !this.isInvulnerable()) {
                this.hurt(DamageSource.playerAttack(var0), Float.MAX_VALUE);
            }
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        if (!this.isFlying() && this.isTame() && this.isOwnedBy(var0)) {
            if (!this.level.isClientSide) {
                this.setOrderedToSit(!this.isOrderedToSit());
            }
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return false;
    }

    public static boolean checkParrotSpawnRules(EntityTypes<EntityParrot> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, Random var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.PARROTS_SPAWNABLE_ON) && EntityParrot.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        return false;
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return null;
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        return var0.hurt(DamageSource.mobAttack(this), 3.0f);
    }

    @Override
    @Nullable
    public SoundEffect getAmbientSound() {
        return EntityParrot.getAmbient(this.level, this.level.random);
    }

    public static SoundEffect getAmbient(World var0, Random var1) {
        if (var0.getDifficulty() != EnumDifficulty.PEACEFUL && var1.nextInt(1000) == 0) {
            ArrayList var2 = Lists.newArrayList(MOB_SOUND_MAP.keySet());
            return EntityParrot.getImitatedSound((EntityTypes)var2.get(var1.nextInt(var2.size())));
        }
        return SoundEffects.PARROT_AMBIENT;
    }

    private static SoundEffect getImitatedSound(EntityTypes<?> var0) {
        return MOB_SOUND_MAP.getOrDefault(var0, SoundEffects.PARROT_AMBIENT);
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PARROT_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PARROT_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.PARROT_STEP, 0.15f, 1.0f);
    }

    @Override
    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    @Override
    protected void onFlap() {
        this.playSound(SoundEffects.PARROT_FLY, 0.15f, 1.0f);
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    @Override
    public float getVoicePitch() {
        return EntityParrot.getPitch(this.random);
    }

    public static float getPitch(Random var0) {
        return (var0.nextFloat() - var0.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.NEUTRAL;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    protected void doPush(Entity var0) {
        if (var0 instanceof EntityHuman) {
            return;
        }
        super.doPush(var0);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        this.setOrderedToSit(false);
        return super.hurt(var0, var1);
    }

    public int getVariant() {
        return MathHelper.clamp(this.entityData.get(DATA_VARIANT_ID), 0, 4);
    }

    public void setVariant(int var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_VARIANT_ID, 0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Variant", this.getVariant());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setVariant(var0.getInt("Variant"));
    }

    @Override
    public boolean isFlying() {
        return !this.onGround;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.5f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature var0, double var1) {
            super(var0, var1);
        }

        @Override
        @Nullable
        protected Vec3D getPosition() {
            Vec3D var0 = null;
            if (this.mob.isInWater()) {
                var0 = LandRandomPos.getPos(this.mob, 15, 15);
            }
            if (this.mob.getRandom().nextFloat() >= this.probability) {
                var0 = this.getTreePos();
            }
            return var0 == null ? super.getPosition() : var0;
        }

        @Nullable
        private Vec3D getTreePos() {
            BlockPosition var0 = this.mob.blockPosition();
            BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition();
            Iterable<BlockPosition> var3 = BlockPosition.betweenClosed(MathHelper.floor(this.mob.getX() - 3.0), MathHelper.floor(this.mob.getY() - 6.0), MathHelper.floor(this.mob.getZ() - 3.0), MathHelper.floor(this.mob.getX() + 3.0), MathHelper.floor(this.mob.getY() + 6.0), MathHelper.floor(this.mob.getZ() + 3.0));
            for (BlockPosition var5 : var3) {
                IBlockData var6;
                boolean var7;
                if (var0.equals(var5) || !(var7 = (var6 = this.mob.level.getBlockState(var2.setWithOffset((BaseBlockPosition)var5, EnumDirection.DOWN))).getBlock() instanceof BlockLeaves || var6.is(TagsBlock.LOGS)) || !this.mob.level.isEmptyBlock(var5) || !this.mob.level.isEmptyBlock(var1.setWithOffset((BaseBlockPosition)var5, EnumDirection.UP))) continue;
                return Vec3D.atBottomCenterOf(var5);
            }
            return null;
        }
    }
}

