/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;

public abstract class EntityAnimal
extends EntityAgeable {
    static final int PARENT_AGE_AFTER_BREEDING = 6000;
    public int inLove;
    @Nullable
    public UUID loveCause;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> var0, World var1) {
        super((EntityTypes<? extends EntityAgeable>)var0, var1);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    @Override
    protected void customServerAiStep() {
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        super.customServerAiStep();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double var0 = this.random.nextGaussian() * 0.02;
                double var2 = this.random.nextGaussian() * 0.02;
                double var4 = this.random.nextGaussian() * 0.02;
                this.level.addParticle(Particles.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), var0, var2, var4);
            }
        }
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        this.inLove = 0;
        return super.hurt(var0, var1);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getBlockState(var0.below()).is(Blocks.GRASS_BLOCK)) {
            return 10.0f;
        }
        return var1.getBrightness(var0) - 0.5f;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("InLove", this.inLove);
        if (this.loveCause != null) {
            var0.putUUID("LoveCause", this.loveCause);
        }
    }

    @Override
    public double getMyRidingOffset() {
        return 0.14;
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.inLove = var0.getInt("InLove");
        this.loveCause = var0.hasUUID("LoveCause") ? var0.getUUID("LoveCause") : null;
    }

    public static boolean checkAnimalSpawnRules(EntityTypes<? extends EntityAnimal> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, Random var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.ANIMALS_SPAWNABLE_ON) && EntityAnimal.isBrightEnoughToSpawn(var1, var3);
    }

    protected static boolean isBrightEnoughToSpawn(IBlockLightAccess var0, BlockPosition var1) {
        return var0.getRawBrightness(var1, 0) > 8;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return false;
    }

    @Override
    protected int getExperienceReward(EntityHuman var0) {
        return 1 + this.level.random.nextInt(3);
    }

    public boolean isFood(ItemStack var0) {
        return var0.is(Items.WHEAT);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (this.isFood(var2)) {
            int var3 = this.getAge();
            if (!this.level.isClientSide && var3 == 0 && this.canFallInLove()) {
                this.usePlayerItem(var0, var1, var2);
                this.setInLove(var0);
                this.gameEvent(GameEvent.MOB_INTERACT, this.eyeBlockPosition());
                return EnumInteractionResult.SUCCESS;
            }
            if (this.isBaby()) {
                this.usePlayerItem(var0, var1, var2);
                this.ageUp((int)((float)(-var3 / 20) * 0.1f), true);
                this.gameEvent(GameEvent.MOB_INTERACT, this.eyeBlockPosition());
                return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
            }
            if (this.level.isClientSide) {
                return EnumInteractionResult.CONSUME;
            }
        }
        return super.mobInteract(var0, var1);
    }

    protected void usePlayerItem(EntityHuman var0, EnumHand var1, ItemStack var2) {
        if (!var0.getAbilities().instabuild) {
            var2.shrink(1);
        }
    }

    public boolean canFallInLove() {
        return this.inLove <= 0;
    }

    public void setInLove(@Nullable EntityHuman var0) {
        this.inLove = 600;
        if (var0 != null) {
            this.loveCause = var0.getUUID();
        }
        this.level.broadcastEntityEvent(this, (byte)18);
    }

    public void setInLoveTime(int var0) {
        this.inLove = var0;
    }

    public int getInLoveTime() {
        return this.inLove;
    }

    @Nullable
    public EntityPlayer getLoveCause() {
        if (this.loveCause == null) {
            return null;
        }
        EntityHuman var0 = this.level.getPlayerByUUID(this.loveCause);
        if (var0 instanceof EntityPlayer) {
            return (EntityPlayer)var0;
        }
        return null;
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetLove() {
        this.inLove = 0;
    }

    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) {
            return false;
        }
        if (var0.getClass() != this.getClass()) {
            return false;
        }
        return this.isInLove() && var0.isInLove();
    }

    public void spawnChildFromBreeding(WorldServer var0, EntityAnimal var1) {
        EntityAgeable var2 = this.getBreedOffspring(var0, var1);
        if (var2 == null) {
            return;
        }
        EntityPlayer var3 = this.getLoveCause();
        if (var3 == null && var1.getLoveCause() != null) {
            var3 = var1.getLoveCause();
        }
        if (var3 != null) {
            var3.awardStat(StatisticList.ANIMALS_BRED);
            CriterionTriggers.BRED_ANIMALS.trigger(var3, this, var1, var2);
        }
        this.setAge(6000);
        var1.setAge(6000);
        this.resetLove();
        var1.resetLove();
        var2.setBaby(true);
        var2.moveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
        var0.addFreshEntityWithPassengers(var2);
        var0.broadcastEntityEvent(this, (byte)18);
        if (var0.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            var0.addFreshEntity(new EntityExperienceOrb(var0, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 18) {
            for (int var1 = 0; var1 < 7; ++var1) {
                double var2 = this.random.nextGaussian() * 0.02;
                double var4 = this.random.nextGaussian() * 0.02;
                double var6 = this.random.nextGaussian() * 0.02;
                this.level.addParticle(Particles.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), var2, var4, var6);
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }
}

