/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillageSiege
implements MobSpawner {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean hasSetupSiege;
    private State siegeState = State.SIEGE_DONE;
    private int zombiesToSpawn;
    private int nextSpawnTime;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    @Override
    public int tick(WorldServer var0, boolean var1, boolean var2) {
        if (var0.isDay() || !var1) {
            this.siegeState = State.SIEGE_DONE;
            this.hasSetupSiege = false;
            return 0;
        }
        float var3 = var0.getTimeOfDay(0.0f);
        if ((double)var3 == 0.5) {
            State state = this.siegeState = var0.random.nextInt(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
        }
        if (this.siegeState == State.SIEGE_DONE) {
            return 0;
        }
        if (!this.hasSetupSiege) {
            if (this.tryToSetupSiege(var0)) {
                this.hasSetupSiege = true;
            } else {
                return 0;
            }
        }
        if (this.nextSpawnTime > 0) {
            --this.nextSpawnTime;
            return 0;
        }
        this.nextSpawnTime = 2;
        if (this.zombiesToSpawn > 0) {
            this.trySpawn(var0);
            --this.zombiesToSpawn;
        } else {
            this.siegeState = State.SIEGE_DONE;
        }
        return 1;
    }

    private boolean tryToSetupSiege(WorldServer var0) {
        for (EntityHuman entityHuman : var0.players()) {
            BlockPosition var3;
            if (entityHuman.isSpectator() || !var0.isVillage(var3 = entityHuman.blockPosition()) || var0.getBiome(var3).getBiomeCategory() == BiomeBase.Geography.MUSHROOM) continue;
            for (int var4 = 0; var4 < 10; ++var4) {
                float var5 = var0.random.nextFloat() * ((float)Math.PI * 2);
                this.spawnX = var3.getX() + MathHelper.floor(MathHelper.cos(var5) * 32.0f);
                this.spawnY = var3.getY();
                this.spawnZ = var3.getZ() + MathHelper.floor(MathHelper.sin(var5) * 32.0f);
                if (this.findRandomSpawnPos(var0, new BlockPosition(this.spawnX, this.spawnY, this.spawnZ)) == null) continue;
                this.nextSpawnTime = 0;
                this.zombiesToSpawn = 20;
                break;
            }
            return true;
        }
        return false;
    }

    private void trySpawn(WorldServer var0) {
        EntityZombie var2;
        Vec3D var1 = this.findRandomSpawnPos(var0, new BlockPosition(this.spawnX, this.spawnY, this.spawnZ));
        if (var1 == null) {
            return;
        }
        try {
            var2 = new EntityZombie(var0);
            var2.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var2.blockPosition()), EnumMobSpawn.EVENT, null, null);
        }
        catch (Exception var3) {
            LOGGER.warn("Failed to create zombie for village siege at {}", (Object)var1, (Object)var3);
            return;
        }
        var2.moveTo(var1.x, var1.y, var1.z, var0.random.nextFloat() * 360.0f, 0.0f);
        var0.addFreshEntityWithPassengers(var2);
    }

    @Nullable
    private Vec3D findRandomSpawnPos(WorldServer var0, BlockPosition var1) {
        for (int var2 = 0; var2 < 10; ++var2) {
            int var4;
            int var5;
            int var3 = var1.getX() + var0.random.nextInt(16) - 8;
            BlockPosition var6 = new BlockPosition(var3, var5 = var0.getHeight(HeightMap.Type.WORLD_SURFACE, var3, var4 = var1.getZ() + var0.random.nextInt(16) - 8), var4);
            if (!var0.isVillage(var6) || !EntityMonster.checkMonsterSpawnRules(EntityTypes.ZOMBIE, var0, EnumMobSpawn.EVENT, var6, var0.random)) continue;
            return Vec3D.atBottomCenterOf(var6);
        }
        return null;
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State SIEGE_CAN_ACTIVATE = new State();
        public static final /* enum */ State SIEGE_TONIGHT = new State();
        public static final /* enum */ State SIEGE_DONE = new State();
        private static final /* synthetic */ State[] d;

        public static State[] values() {
            return (State[])d.clone();
        }

        public static State valueOf(String var0) {
            return Enum.valueOf(State.class, var0);
        }

        private static /* synthetic */ State[] a() {
            return new State[]{SIEGE_CAN_ACTIVATE, SIEGE_TONIGHT, SIEGE_DONE};
        }

        static {
            d = State.a();
        }
    }
}

