/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import net.minecraft.tags.TagsEntity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class AxolotlAttackablesSensor
extends NearestVisibleLivingEntitySensor {
    public static final float TARGET_DETECTION_DISTANCE = 8.0f;

    @Override
    protected boolean isMatchingEntity(EntityLiving var0, EntityLiving var1) {
        return this.isClose(var0, var1) && var1.isInWaterOrBubble() && (this.isHostileTarget(var1) || this.isHuntTarget(var0, var1)) && Sensor.isEntityAttackable(var0, var1);
    }

    private boolean isHuntTarget(EntityLiving var0, EntityLiving var1) {
        return !var0.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN) && TagsEntity.AXOLOTL_HUNT_TARGETS.contains(var1.getType());
    }

    private boolean isHostileTarget(EntityLiving var0) {
        return TagsEntity.AXOLOTL_ALWAYS_HOSTILES.contains(var0.getType());
    }

    private boolean isClose(EntityLiving var0, EntityLiving var1) {
        return var1.distanceToSqr(var0) <= 64.0;
    }

    @Override
    protected MemoryModuleType<EntityLiving> getMemory() {
        return MemoryModuleType.NEAREST_ATTACKABLE;
    }
}

