/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.AxisAlignedBB;

public class PathfinderGoalDefendVillage
extends PathfinderGoalTarget {
    private final EntityIronGolem golem;
    @Nullable
    private EntityLiving potentialTarget;
    private final PathfinderTargetCondition attackTargeting = PathfinderTargetCondition.forCombat().range(64.0);

    public PathfinderGoalDefendVillage(EntityIronGolem var0) {
        super(var0, false, true);
        this.golem = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.TARGET));
    }

    @Override
    public boolean canUse() {
        AxisAlignedBB var0 = this.golem.getBoundingBox().inflate(10.0, 8.0, 10.0);
        List<EntityVillager> var1 = this.golem.level.getNearbyEntities(EntityVillager.class, this.attackTargeting, this.golem, var0);
        List<EntityHuman> var2 = this.golem.level.getNearbyPlayers(this.attackTargeting, this.golem, var0);
        for (EntityLiving entityLiving : var1) {
            EntityVillager var5 = (EntityVillager)entityLiving;
            for (EntityHuman var7 : var2) {
                int var8 = var5.getPlayerReputation(var7);
                if (var8 > -100) continue;
                this.potentialTarget = var7;
            }
        }
        if (this.potentialTarget == null) {
            return false;
        }
        return !(this.potentialTarget instanceof EntityHuman) || !this.potentialTarget.isSpectator() && !((EntityHuman)this.potentialTarget).isCreative();
    }

    @Override
    public void start() {
        this.golem.setTarget(this.potentialTarget);
        super.start();
    }
}

