/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalRaid<T extends EntityRaider>
extends PathfinderGoal {
    private static final float SPEED_MODIFIER = 1.0f;
    private final T mob;

    public PathfinderGoalRaid(T var0) {
        this.mob = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canUse() {
        return ((EntityInsentient)this.mob).getTarget() == null && !((Entity)this.mob).isVehicle() && ((EntityRaider)this.mob).hasActiveRaid() && !((EntityRaider)this.mob).getCurrentRaid().isOver() && !((WorldServer)((EntityRaider)this.mob).level).isVillage(((Entity)this.mob).blockPosition());
    }

    @Override
    public boolean canContinueToUse() {
        return ((EntityRaider)this.mob).hasActiveRaid() && !((EntityRaider)this.mob).getCurrentRaid().isOver() && ((EntityRaider)this.mob).level instanceof WorldServer && !((WorldServer)((EntityRaider)this.mob).level).isVillage(((Entity)this.mob).blockPosition());
    }

    @Override
    public void tick() {
        if (((EntityRaider)this.mob).hasActiveRaid()) {
            Vec3D var1;
            Raid var0 = ((EntityRaider)this.mob).getCurrentRaid();
            if (((EntityRaider)this.mob).tickCount % 20 == ((Entity)this.mob).getId() % 2) {
                this.recruitNearby(var0);
            }
            if (!((EntityCreature)this.mob).isPathFinding() && (var1 = DefaultRandomPos.getPosTowards(this.mob, 15, 4, Vec3D.atBottomCenterOf(var0.getCenter()), 1.5707963705062866)) != null) {
                ((EntityInsentient)this.mob).getNavigation().moveTo(var1.x, var1.y, var1.z, 1.0);
            }
        }
    }

    private void recruitNearby(Raid var0) {
        if (var0.isActive()) {
            HashSet var12 = Sets.newHashSet();
            List<EntityRaider> var2 = ((EntityRaider)this.mob).level.getEntitiesOfClass(EntityRaider.class, ((Entity)this.mob).getBoundingBox().inflate(16.0), var1 -> !var1.hasActiveRaid() && PersistentRaid.canJoinRaid(var1, var0));
            var12.addAll(var2);
            for (EntityRaider var4 : var12) {
                var0.joinRaid(var0.getGroupsSpawned(), var4, null, true);
            }
        }
    }
}

