/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.level.IWorldReader;

public abstract class PathfinderGoalGotoTarget
extends PathfinderGoal {
    private static final int GIVE_UP_TICKS = 1200;
    private static final int STAY_TICKS = 1200;
    private static final int INTERVAL_TICKS = 200;
    protected final EntityCreature mob;
    public final double speedModifier;
    protected int nextStartTick;
    protected int tryTicks;
    private int maxStayTicks;
    protected BlockPosition blockPos = BlockPosition.ZERO;
    private boolean reachedTarget;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int verticalSearchStart;

    public PathfinderGoalGotoTarget(EntityCreature var0, double var1, int var3) {
        this(var0, var1, var3, 1);
    }

    public PathfinderGoalGotoTarget(EntityCreature var0, double var1, int var3, int var4) {
        this.mob = var0;
        this.speedModifier = var1;
        this.searchRange = var3;
        this.verticalSearchStart = 0;
        this.verticalSearchRange = var4;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.JUMP));
    }

    @Override
    public boolean canUse() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return this.findNearestBlock();
    }

    protected int nextStartTick(EntityCreature var0) {
        return PathfinderGoalGotoTarget.reducedTickDelay(200 + var0.getRandom().nextInt(200));
    }

    @Override
    public boolean canContinueToUse() {
        return this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200 && this.isValidTarget(this.mob.level, this.blockPos);
    }

    @Override
    public void start() {
        this.moveMobToBlock();
        this.tryTicks = 0;
        this.maxStayTicks = this.mob.getRandom().nextInt(this.mob.getRandom().nextInt(1200) + 1200) + 1200;
    }

    protected void moveMobToBlock() {
        this.mob.getNavigation().moveTo((double)this.blockPos.getX() + 0.5, this.blockPos.getY() + 1, (double)this.blockPos.getZ() + 0.5, this.speedModifier);
    }

    public double acceptedDistance() {
        return 1.0;
    }

    protected BlockPosition getMoveToTarget() {
        return this.blockPos.above();
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void tick() {
        BlockPosition var0 = this.getMoveToTarget();
        if (!var0.closerThan(this.mob.position(), this.acceptedDistance())) {
            this.reachedTarget = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                this.mob.getNavigation().moveTo((double)var0.getX() + 0.5, var0.getY(), (double)var0.getZ() + 0.5, this.speedModifier);
            }
        } else {
            this.reachedTarget = true;
            --this.tryTicks;
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    protected boolean isReachedTarget() {
        return this.reachedTarget;
    }

    protected boolean findNearestBlock() {
        int var0 = this.searchRange;
        int var1 = this.verticalSearchRange;
        BlockPosition var2 = this.mob.blockPosition();
        BlockPosition.MutableBlockPosition var3 = new BlockPosition.MutableBlockPosition();
        int var4 = this.verticalSearchStart;
        while (var4 <= var1) {
            for (int var5 = 0; var5 < var0; ++var5) {
                int var6 = 0;
                while (var6 <= var5) {
                    int var7;
                    int n2 = var7 = var6 < var5 && var6 > -var5 ? var5 : 0;
                    while (var7 <= var5) {
                        var3.setWithOffset(var2, var6, var4 - 1, var7);
                        if (this.mob.isWithinRestriction(var3) && this.isValidTarget(this.mob.level, var3)) {
                            this.blockPos = var3;
                            return true;
                        }
                        var7 = var7 > 0 ? -var7 : 1 - var7;
                    }
                    var6 = var6 > 0 ? -var6 : 1 - var6;
                }
            }
            var4 = var4 > 0 ? -var4 : 1 - var4;
        }
        return false;
    }

    protected abstract boolean isValidTarget(IWorldReader var1, BlockPosition var2);
}

