/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.Items;

public class PathfinderGoalBowShoot<T extends EntityMonster>
extends PathfinderGoal {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public PathfinderGoalBowShoot(T var0, double var1, int var3, float var4) {
        this.mob = var0;
        this.speedModifier = var1;
        this.attackIntervalMin = var3;
        this.attackRadiusSqr = var4 * var4;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
    }

    public void setMinAttackInterval(int var0) {
        this.attackIntervalMin = var0;
    }

    @Override
    public boolean canUse() {
        if (((EntityInsentient)this.mob).getTarget() == null) {
            return false;
        }
        return this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return ((EntityLiving)this.mob).isHolding(Items.BOW);
    }

    @Override
    public boolean canContinueToUse() {
        return (this.canUse() || !((EntityInsentient)this.mob).getNavigation().isDone()) && this.isHoldingBow();
    }

    @Override
    public void start() {
        super.start();
        ((EntityInsentient)this.mob).setAggressive(true);
    }

    @Override
    public void stop() {
        super.stop();
        ((EntityInsentient)this.mob).setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        ((EntityLiving)this.mob).stopUsingItem();
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void tick() {
        boolean var4;
        EntityLiving var0 = ((EntityInsentient)this.mob).getTarget();
        if (var0 == null) {
            return;
        }
        double var1 = ((Entity)this.mob).distanceToSqr(var0.getX(), var0.getY(), var0.getZ());
        boolean var3 = ((EntityInsentient)this.mob).getSensing().hasLineOfSight(var0);
        boolean bl = var4 = this.seeTime > 0;
        if (var3 != var4) {
            this.seeTime = 0;
        }
        this.seeTime = var3 ? ++this.seeTime : --this.seeTime;
        if (var1 > (double)this.attackRadiusSqr || this.seeTime < 20) {
            ((EntityInsentient)this.mob).getNavigation().moveTo(var0, this.speedModifier);
            this.strafingTime = -1;
        } else {
            ((EntityInsentient)this.mob).getNavigation().stop();
            ++this.strafingTime;
        }
        if (this.strafingTime >= 20) {
            if ((double)((EntityLiving)this.mob).getRandom().nextFloat() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)((EntityLiving)this.mob).getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (var1 > (double)(this.attackRadiusSqr * 0.75f)) {
                this.strafingBackwards = false;
            } else if (var1 < (double)(this.attackRadiusSqr * 0.25f)) {
                this.strafingBackwards = true;
            }
            ((EntityInsentient)this.mob).getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            ((EntityInsentient)this.mob).lookAt(var0, 30.0f, 30.0f);
        } else {
            ((EntityInsentient)this.mob).getLookControl().setLookAt(var0, 30.0f, 30.0f);
        }
        if (((EntityLiving)this.mob).isUsingItem()) {
            int var5;
            if (!var3 && this.seeTime < -60) {
                ((EntityLiving)this.mob).stopUsingItem();
            } else if (var3 && (var5 = ((EntityLiving)this.mob).getTicksUsingItem()) >= 20) {
                ((EntityLiving)this.mob).stopUsingItem();
                ((IRangedEntity)this.mob).performRangedAttack(var0, ItemBow.getPowerForTime(var5));
                this.attackTime = this.attackIntervalMin;
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            ((EntityLiving)this.mob).startUsingItem(ProjectileHelper.getWeaponHoldingHand(this.mob, Items.BOW));
        }
    }
}

