/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;

public class BehaviorWalkAwayOutOfRange
extends Behavior<EntityInsentient> {
    private static final int PROJECTILE_ATTACK_RANGE_BUFFER = 1;
    private final Function<EntityLiving, Float> speedModifier;

    public BehaviorWalkAwayOutOfRange(float var0) {
        this((EntityLiving var1) -> Float.valueOf(var0));
    }

    public BehaviorWalkAwayOutOfRange(Function<EntityLiving, Float> var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.REGISTERED)));
        this.speedModifier = var0;
    }

    @Override
    protected void start(WorldServer var0, EntityInsentient var1, long var2) {
        EntityLiving var4 = var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        if (BehaviorUtil.canSee(var1, var4) && BehaviorUtil.isWithinAttackRange(var1, var4, 1)) {
            this.clearWalkTarget(var1);
        } else {
            this.setWalkAndLookTarget(var1, var4);
        }
    }

    private void setWalkAndLookTarget(EntityLiving var0, EntityLiving var1) {
        BehaviorController<?> var2 = var0.getBrain();
        var2.setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var1, true));
        MemoryTarget var3 = new MemoryTarget(new BehaviorPositionEntity(var1, false), this.speedModifier.apply(var0).floatValue(), 0);
        var2.setMemory(MemoryModuleType.WALK_TARGET, var3);
    }

    private void clearWalkTarget(EntityLiving var0) {
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }
}

