/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;

public class BehaviorStrollRandom
extends Behavior<EntityCreature> {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;
    private final float speedModifier;
    private final int maxXyDist;
    private final int maxYDist;

    public BehaviorStrollRandom(float var0) {
        this(var0, 10, 7);
    }

    public BehaviorStrollRandom(float var0, int var1, int var2) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
        this.maxXyDist = var1;
        this.maxYDist = var2;
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        BlockPosition var4 = var1.blockPosition();
        if (var0.isVillage(var4)) {
            this.setRandomPos(var1);
        } else {
            SectionPosition var5 = SectionPosition.of(var4);
            SectionPosition var6 = BehaviorUtil.findSectionClosestToVillage(var0, var5, 2);
            if (var6 != var5) {
                this.setTargetedPos(var1, var6);
            } else {
                this.setRandomPos(var1);
            }
        }
    }

    private void setTargetedPos(EntityCreature var02, SectionPosition var1) {
        Optional<Vec3D> var2 = Optional.ofNullable(DefaultRandomPos.getPosTowards(var02, this.maxXyDist, this.maxYDist, Vec3D.atBottomCenterOf(var1.center()), 1.5707963705062866));
        var02.getBrain().setMemory(MemoryModuleType.WALK_TARGET, var2.map(var0 -> new MemoryTarget((Vec3D)var0, this.speedModifier, 0)));
    }

    private void setRandomPos(EntityCreature var02) {
        Optional<Vec3D> var1 = Optional.ofNullable(LandRandomPos.getPos(var02, this.maxXyDist, this.maxYDist));
        var02.getBrain().setMemory(MemoryModuleType.WALK_TARGET, var1.map(var0 -> new MemoryTarget((Vec3D)var0, this.speedModifier, 0)));
    }
}

