/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.npc.EntityVillager;

public class BehaviorStrollPlaceList
extends Behavior<EntityVillager> {
    private final MemoryModuleType<List<GlobalPos>> strollToMemoryType;
    private final MemoryModuleType<GlobalPos> mustBeCloseToMemoryType;
    private final float speedModifier;
    private final int closeEnoughDist;
    private final int maxDistanceFromPoi;
    private long nextOkStartTime;
    @Nullable
    private GlobalPos targetPos;

    public BehaviorStrollPlaceList(MemoryModuleType<List<GlobalPos>> var0, float var1, int var2, int var3, MemoryModuleType<GlobalPos> var4) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), var0, (Object)((Object)MemoryStatus.VALUE_PRESENT), var4, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.strollToMemoryType = var0;
        this.speedModifier = var1;
        this.closeEnoughDist = var2;
        this.maxDistanceFromPoi = var3;
        this.mustBeCloseToMemoryType = var4;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        List<GlobalPos> var4;
        Optional<List<GlobalPos>> var2 = var1.getBrain().getMemory(this.strollToMemoryType);
        Optional<GlobalPos> var3 = var1.getBrain().getMemory(this.mustBeCloseToMemoryType);
        if (var2.isPresent() && var3.isPresent() && !(var4 = var2.get()).isEmpty()) {
            this.targetPos = var4.get(var0.getRandom().nextInt(var4.size()));
            return this.targetPos != null && var0.dimension() == this.targetPos.dimension() && var3.get().pos().closerThan(var1.position(), (double)this.maxDistanceFromPoi);
        }
        return false;
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        if (var2 > this.nextOkStartTime && this.targetPos != null) {
            var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(this.targetPos.pos(), this.speedModifier, this.closeEnoughDist));
            this.nextOkStartTime = var2 + 100L;
        }
    }
}

