/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorStartRiding<E extends EntityLiving>
extends Behavior<E> {
    private static final int CLOSE_ENOUGH_TO_START_RIDING_DIST = 1;
    private final float speedModifier;

    public BehaviorStartRiding(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.RIDE_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return !((Entity)var1).isPassenger();
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        if (this.isCloseEnoughToStartRiding(var1)) {
            ((Entity)var1).startRiding(this.getRidableEntity(var1));
        } else {
            BehaviorUtil.setWalkAndLookTargetMemories(var1, this.getRidableEntity(var1), this.speedModifier, 1);
        }
    }

    private boolean isCloseEnoughToStartRiding(E var0) {
        return this.getRidableEntity(var0).closerThan((Entity)var0, 1.0);
    }

    private Entity getRidableEntity(E var0) {
        return ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.RIDE_TARGET).get();
    }
}

