/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;

public class BehaviorPositionValidate
extends Behavior<EntityLiving> {
    private static final int MAX_DISTANCE = 16;
    private final MemoryModuleType<GlobalPos> memoryType;
    private final Predicate<VillagePlaceType> poiPredicate;

    public BehaviorPositionValidate(VillagePlaceType var0, MemoryModuleType<GlobalPos> var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(var1, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.poiPredicate = var0.getPredicate();
        this.memoryType = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityLiving var1) {
        GlobalPos var2 = var1.getBrain().getMemory(this.memoryType).get();
        return var0.dimension() == var2.dimension() && var2.pos().closerThan(var1.position(), 16.0);
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var1, long var2) {
        BehaviorController<?> var4 = var1.getBrain();
        GlobalPos var5 = var4.getMemory(this.memoryType).get();
        BlockPosition var6 = var5.pos();
        WorldServer var7 = var0.getServer().getLevel(var5.dimension());
        if (var7 == null || this.poiDoesntExist(var7, var6)) {
            var4.eraseMemory(this.memoryType);
        } else if (this.bedIsOccupied(var7, var6, var1)) {
            var4.eraseMemory(this.memoryType);
            var0.getPoiManager().release(var6);
            PacketDebug.sendPoiTicketCountPacket(var0, var6);
        }
    }

    private boolean bedIsOccupied(WorldServer var0, BlockPosition var1, EntityLiving var2) {
        IBlockData var3 = var0.getBlockState(var1);
        return var3.is(TagsBlock.BEDS) && var3.getValue(BlockBed.OCCUPIED) != false && !var2.isSleeping();
    }

    private boolean poiDoesntExist(WorldServer var0, BlockPosition var1) {
        return !var0.getPoiManager().exists(var1, this.poiPredicate);
    }
}

