/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.pathfinder.PathEntity;

public class BehaviorLeaveJob
extends Behavior<EntityVillager> {
    private final float speedModifier;

    public BehaviorLeaveJob(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.POTENTIAL_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.JOB_SITE, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        if (var1.isBaby()) {
            return false;
        }
        return var1.getVillagerData().getProfession() == VillagerProfession.NONE;
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var22) {
        BlockPosition var4 = var1.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).get().pos();
        Optional<VillagePlaceType> var5 = var0.getPoiManager().getType(var4);
        if (!var5.isPresent()) {
            return;
        }
        BehaviorUtil.getNearbyVillagersWithCondition(var1, var2 -> this.nearbyWantsJobsite((VillagePlaceType)var5.get(), (EntityVillager)var2, var4)).findFirst().ifPresent(var3 -> this.yieldJobSite(var0, var1, (EntityVillager)var3, var4, var3.getBrain().getMemory(MemoryModuleType.JOB_SITE).isPresent()));
    }

    private boolean nearbyWantsJobsite(VillagePlaceType var0, EntityVillager var1, BlockPosition var2) {
        boolean var3 = var1.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).isPresent();
        if (var3) {
            return false;
        }
        Optional<GlobalPos> var4 = var1.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        VillagerProfession var5 = var1.getVillagerData().getProfession();
        if (var1.getVillagerData().getProfession() != VillagerProfession.NONE && var5.getJobPoiType().getPredicate().test(var0)) {
            if (!var4.isPresent()) {
                return this.canReachPos(var1, var2, var0);
            }
            return var4.get().pos().equals(var2);
        }
        return false;
    }

    private void yieldJobSite(WorldServer var0, EntityVillager var1, EntityVillager var2, BlockPosition var3, boolean var4) {
        this.eraseMemories(var1);
        if (!var4) {
            BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var2, var3, this.speedModifier, 1);
            var2.getBrain().setMemory(MemoryModuleType.POTENTIAL_JOB_SITE, GlobalPos.of(var0.dimension(), var3));
            PacketDebug.sendPoiTicketCountPacket(var0, var3);
        }
    }

    private boolean canReachPos(EntityVillager var0, BlockPosition var1, VillagePlaceType var2) {
        PathEntity var3 = var0.getNavigation().createPath(var1, var2.getValidRange());
        return var3 != null && var3.canReach();
    }

    private void eraseMemories(EntityVillager var0) {
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var0.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        var0.getBrain().eraseMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
    }
}

