/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;

public class BehaviorInteractDoor
extends Behavior<EntityLiving> {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 20;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 2.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;
    @Nullable
    private PathPoint lastCheckedNode;
    private int remainingCooldown;

    public BehaviorInteractDoor() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.PATH, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.DOORS_TO_CLOSE, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityLiving var1) {
        PathEntity var2 = var1.getBrain().getMemory(MemoryModuleType.PATH).get();
        if (var2.notStarted() || var2.isDone()) {
            return false;
        }
        if (!Objects.equals(this.lastCheckedNode, var2.getNextNode())) {
            this.remainingCooldown = 20;
            return true;
        }
        if (this.remainingCooldown > 0) {
            --this.remainingCooldown;
        }
        return this.remainingCooldown == 0;
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var1, long var2) {
        BlockDoor var11;
        IBlockData var10;
        Object var9;
        PathEntity var4 = var1.getBrain().getMemory(MemoryModuleType.PATH).get();
        this.lastCheckedNode = var4.getNextNode();
        PathPoint var5 = var4.getPreviousNode();
        PathPoint var6 = var4.getNextNode();
        BlockPosition var7 = var5.asBlockPos();
        IBlockData var8 = var0.getBlockState(var7);
        if (var8.is(TagsBlock.WOODEN_DOORS)) {
            var9 = (BlockDoor)var8.getBlock();
            if (!((BlockDoor)var9).isOpen(var8)) {
                ((BlockDoor)var9).setOpen(var1, var0, var8, var7, true);
            }
            this.rememberDoorToClose(var0, var1, var7);
        }
        if ((var10 = var0.getBlockState((BlockPosition)(var9 = var6.asBlockPos()))).is(TagsBlock.WOODEN_DOORS) && !(var11 = (BlockDoor)var10.getBlock()).isOpen(var10)) {
            var11.setOpen(var1, var0, var10, (BlockPosition)var9, true);
            this.rememberDoorToClose(var0, var1, (BlockPosition)var9);
        }
        BehaviorInteractDoor.closeDoorsThatIHaveOpenedOrPassedThrough(var0, var1, var5, var6);
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(WorldServer var0, EntityLiving var1, @Nullable PathPoint var2, @Nullable PathPoint var3) {
        BehaviorController<Set<GlobalPos>> var4 = var1.getBrain();
        if (var4.hasMemoryValue(MemoryModuleType.DOORS_TO_CLOSE)) {
            Iterator<GlobalPos> var5 = var4.getMemory(MemoryModuleType.DOORS_TO_CLOSE).get().iterator();
            while (var5.hasNext()) {
                GlobalPos var6 = var5.next();
                BlockPosition var7 = var6.pos();
                if (var2 != null && var2.asBlockPos().equals(var7) || var3 != null && var3.asBlockPos().equals(var7)) continue;
                if (BehaviorInteractDoor.isDoorTooFarAway(var0, var1, var6)) {
                    var5.remove();
                    continue;
                }
                IBlockData var8 = var0.getBlockState(var7);
                if (!var8.is(TagsBlock.WOODEN_DOORS)) {
                    var5.remove();
                    continue;
                }
                BlockDoor var9 = (BlockDoor)var8.getBlock();
                if (!var9.isOpen(var8)) {
                    var5.remove();
                    continue;
                }
                if (BehaviorInteractDoor.areOtherMobsComingThroughDoor(var0, var1, var7)) {
                    var5.remove();
                    continue;
                }
                var9.setOpen(var1, var0, var8, var7, false);
                var5.remove();
            }
        }
    }

    private static boolean areOtherMobsComingThroughDoor(WorldServer var0, EntityLiving var12, BlockPosition var22) {
        BehaviorController<List<EntityLiving>> var3 = var12.getBrain();
        if (!var3.hasMemoryValue(MemoryModuleType.NEAREST_LIVING_ENTITIES)) {
            return false;
        }
        return var3.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).get().stream().filter(var1 -> var1.getType() == var12.getType()).filter(var1 -> var22.closerThan(var1.position(), 2.0)).anyMatch(var2 -> BehaviorInteractDoor.isMobComingThroughDoor(var0, var2, var22));
    }

    private static boolean isMobComingThroughDoor(WorldServer var0, EntityLiving var1, BlockPosition var2) {
        if (!var1.getBrain().hasMemoryValue(MemoryModuleType.PATH)) {
            return false;
        }
        PathEntity var3 = var1.getBrain().getMemory(MemoryModuleType.PATH).get();
        if (var3.isDone()) {
            return false;
        }
        PathPoint var4 = var3.getPreviousNode();
        if (var4 == null) {
            return false;
        }
        PathPoint var5 = var3.getNextNode();
        return var2.equals(var4.asBlockPos()) || var2.equals(var5.asBlockPos());
    }

    private static boolean isDoorTooFarAway(WorldServer var0, EntityLiving var1, GlobalPos var2) {
        return var2.dimension() != var0.dimension() || !var2.pos().closerThan(var1.position(), 2.0);
    }

    private void rememberDoorToClose(WorldServer var0, EntityLiving var1, BlockPosition var2) {
        BehaviorController<?> var3 = var1.getBrain();
        GlobalPos var4 = GlobalPos.of(var0.dimension(), var2);
        if (var3.getMemory(MemoryModuleType.DOORS_TO_CLOSE).isPresent()) {
            var3.getMemory(MemoryModuleType.DOORS_TO_CLOSE).get().add(var4);
        } else {
            var3.setMemory(MemoryModuleType.DOORS_TO_CLOSE, Sets.newHashSet((Object[])new GlobalPos[]{var4}));
        }
    }
}

