/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorHide
extends Behavior<EntityLiving> {
    private static final int HIDE_TIMEOUT = 300;
    private final int closeEnoughDist;
    private final int stayHiddenTicks;
    private int ticksHidden;

    public BehaviorHide(int var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.HIDING_PLACE, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.HEARD_BELL_TIME, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.stayHiddenTicks = var0 * 20;
        this.ticksHidden = 0;
        this.closeEnoughDist = var1;
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var1, long var2) {
        boolean var6;
        BehaviorController<?> var4 = var1.getBrain();
        Optional<Long> var5 = var4.getMemory(MemoryModuleType.HEARD_BELL_TIME);
        boolean bl = var6 = var5.get() + 300L <= var2;
        if (this.ticksHidden > this.stayHiddenTicks || var6) {
            var4.eraseMemory(MemoryModuleType.HEARD_BELL_TIME);
            var4.eraseMemory(MemoryModuleType.HIDING_PLACE);
            var4.updateActivityFromSchedule(var0.getDayTime(), var0.getGameTime());
            this.ticksHidden = 0;
            return;
        }
        BlockPosition var7 = var4.getMemory(MemoryModuleType.HIDING_PLACE).get().pos();
        if (var7.closerThan(var1.blockPosition(), (double)this.closeEnoughDist)) {
            ++this.ticksHidden;
        }
    }
}

