/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorExpirableMemory<E extends EntityInsentient, T>
extends Behavior<E> {
    private final Predicate<E> predicate;
    private final MemoryModuleType<? extends T> sourceMemory;
    private final MemoryModuleType<T> targetMemory;
    private final UniformInt durationOfCopy;

    public BehaviorExpirableMemory(Predicate<E> var0, MemoryModuleType<? extends T> var1, MemoryModuleType<T> var2, UniformInt var3) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(var1, (Object)((Object)MemoryStatus.VALUE_PRESENT), var2, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.predicate = var0;
        this.sourceMemory = var1;
        this.targetMemory = var2;
        this.durationOfCopy = var3;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return this.predicate.test(var1);
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        BehaviorController<?> var4 = ((EntityLiving)var1).getBrain();
        var4.setMemoryWithExpiry(this.targetMemory, var4.getMemory(this.sourceMemory).get(), this.durationOfCopy.sample(var0.random));
    }
}

