/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.GameRules;

public class BehaviorCelebrateDeath
extends Behavior<EntityLiving> {
    private final int celebrateDuration;
    private final BiPredicate<EntityLiving, EntityLiving> dancePredicate;

    public BehaviorCelebrateDeath(int var0, BiPredicate<EntityLiving, EntityLiving> var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ANGRY_AT, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.CELEBRATE_LOCATION, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.DANCING, (Object)((Object)MemoryStatus.REGISTERED)));
        this.celebrateDuration = var0;
        this.dancePredicate = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityLiving var1) {
        return this.getAttackTarget(var1).isDeadOrDying();
    }

    @Override
    protected void start(WorldServer var0, EntityLiving var1, long var2) {
        EntityLiving var4 = this.getAttackTarget(var1);
        if (this.dancePredicate.test(var1, var4)) {
            var1.getBrain().setMemoryWithExpiry(MemoryModuleType.DANCING, true, this.celebrateDuration);
        }
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.CELEBRATE_LOCATION, var4.blockPosition(), this.celebrateDuration);
        if (var4.getType() != EntityTypes.PLAYER || var0.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            var1.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            var1.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
        }
    }

    private EntityLiving getAttackTarget(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }
}

