/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;

public interface IEntityAngerable {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(NBTTagCompound var0) {
        var0.putInt(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        if (this.getPersistentAngerTarget() != null) {
            var0.putUUID(TAG_ANGRY_AT, this.getPersistentAngerTarget());
        }
    }

    default public void readPersistentAngerSaveData(World var0, NBTTagCompound var1) {
        this.setRemainingPersistentAngerTime(var1.getInt(TAG_ANGER_TIME));
        if (!(var0 instanceof WorldServer)) {
            return;
        }
        if (!var1.hasUUID(TAG_ANGRY_AT)) {
            this.setPersistentAngerTarget(null);
            return;
        }
        UUID var2 = var1.getUUID(TAG_ANGRY_AT);
        this.setPersistentAngerTarget(var2);
        Entity var3 = ((WorldServer)var0).getEntity(var2);
        if (var3 == null) {
            return;
        }
        if (var3 instanceof EntityInsentient) {
            this.setLastHurtByMob((EntityInsentient)var3);
        }
        if (var3.getType() == EntityTypes.PLAYER) {
            this.setLastHurtByPlayer((EntityHuman)var3);
        }
    }

    default public void updatePersistentAnger(WorldServer var0, boolean var1) {
        EntityLiving var2 = this.getTarget();
        UUID var3 = this.getPersistentAngerTarget();
        if ((var2 == null || var2.isDeadOrDying()) && var3 != null && var0.getEntity(var3) instanceof EntityInsentient) {
            this.stopBeingAngry();
            return;
        }
        if (var2 != null && !Objects.equals(var3, var2.getUUID())) {
            this.setPersistentAngerTarget(var2.getUUID());
            this.startPersistentAngerTimer();
        }
        if (!(this.getRemainingPersistentAngerTime() <= 0 || var2 != null && var2.getType() == EntityTypes.PLAYER && var1)) {
            this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
            if (this.getRemainingPersistentAngerTime() == 0) {
                this.stopBeingAngry();
            }
        }
    }

    default public boolean isAngryAt(EntityLiving var0) {
        if (!this.canAttack(var0)) {
            return false;
        }
        if (var0.getType() == EntityTypes.PLAYER && this.isAngryAtAllPlayers(var0.level)) {
            return true;
        }
        return var0.getUUID().equals(this.getPersistentAngerTarget());
    }

    default public boolean isAngryAtAllPlayers(World var0) {
        return var0.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void playerDied(EntityHuman var0) {
        if (!var0.level.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            return;
        }
        if (!var0.getUUID().equals(this.getPersistentAngerTarget())) {
            return;
        }
        this.stopBeingAngry();
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public EntityLiving getLastHurtByMob();

    public void setLastHurtByMob(@Nullable EntityLiving var1);

    public void setLastHurtByPlayer(@Nullable EntityHuman var1);

    public void setTarget(@Nullable EntityLiving var1);

    public boolean canAttack(EntityLiving var1);

    @Nullable
    public EntityLiving getTarget();
}

