/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProviderType;

public abstract class IntProvider {
    private static final Codec<Either<Integer, IntProvider>> CONSTANT_OR_DISPATCH_CODEC = Codec.either((Codec)Codec.INT, (Codec)IRegistry.INT_PROVIDER_TYPES.byNameCodec().dispatch(IntProvider::getType, IntProviderType::codec));
    public static final Codec<IntProvider> CODEC = CONSTANT_OR_DISPATCH_CODEC.xmap(var02 -> (IntProvider)var02.map(ConstantInt::of, var0 -> var0), var0 -> var0.getType() == IntProviderType.CONSTANT ? Either.left((Object)((ConstantInt)var0).getValue()) : Either.right((Object)var0));
    public static final Codec<IntProvider> NON_NEGATIVE_CODEC = IntProvider.codec(0, Integer.MAX_VALUE);
    public static final Codec<IntProvider> POSITIVE_CODEC = IntProvider.codec(1, Integer.MAX_VALUE);

    public static Codec<IntProvider> codec(int var0, int var1) {
        Function<IntProvider, DataResult> var22 = var2 -> {
            if (var2.getMinValue() < var0) {
                return DataResult.error((String)("Value provider too low: " + var0 + " [" + var2.getMinValue() + "-" + var2.getMaxValue() + "]"));
            }
            if (var2.getMaxValue() > var1) {
                return DataResult.error((String)("Value provider too high: " + var1 + " [" + var2.getMinValue() + "-" + var2.getMaxValue() + "]"));
            }
            return DataResult.success((Object)var2);
        };
        return CODEC.flatXmap(var22, var22);
    }

    public abstract int sample(Random var1);

    public abstract int getMinValue();

    public abstract int getMaxValue();

    public abstract IntProviderType<?> getType();
}

