/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.SummaryReporter;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.jfr.event.ChunkGenerationEvent;
import net.minecraft.util.profiling.jfr.event.NetworkSummaryEvent;
import net.minecraft.util.profiling.jfr.event.PacketReceivedEvent;
import net.minecraft.util.profiling.jfr.event.PacketSentEvent;
import net.minecraft.util.profiling.jfr.event.ServerTickTimeEvent;
import net.minecraft.util.profiling.jfr.event.WorldLoadFinishedEvent;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JfrProfiler
implements JvmProfiler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String ROOT_CATEGORY = "Minecraft";
    public static final String WORLD_GEN_CATEGORY = "World Generation";
    public static final String TICK_CATEGORY = "Ticking";
    public static final String NETWORK_CATEGORY = "Network";
    private static final List<Class<? extends Event>> CUSTOM_EVENTS = List.of(ChunkGenerationEvent.class, PacketReceivedEvent.class, PacketSentEvent.class, NetworkSummaryEvent.class, ServerTickTimeEvent.class, WorldLoadFinishedEvent.class);
    private static final String FLIGHT_RECORDER_CONFIG = "/flightrecorder-config.jfc";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd-HHmmss").toFormatter().withZone(ZoneId.systemDefault());
    private static final JfrProfiler INSTANCE = new JfrProfiler();
    @Nullable
    Recording recording;
    private float currentAverageTickTime;
    private final Map<String, NetworkSummaryEvent.b> networkTrafficByAddress = new ConcurrentHashMap<String, NetworkSummaryEvent.b>();

    private JfrProfiler() {
        CUSTOM_EVENTS.forEach(FlightRecorder::register);
        FlightRecorder.addPeriodicEvent(ServerTickTimeEvent.class, () -> new ServerTickTimeEvent(this.currentAverageTickTime).commit());
        FlightRecorder.addPeriodicEvent(NetworkSummaryEvent.class, () -> {
            Iterator<NetworkSummaryEvent.b> var0 = this.networkTrafficByAddress.values().iterator();
            while (var0.hasNext()) {
                var0.next().commitEvent();
                var0.remove();
            }
        });
    }

    public static JfrProfiler getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean start(Environment var0) {
        boolean bl;
        URL var1 = JfrProfiler.class.getResource(FLIGHT_RECORDER_CONFIG);
        if (var1 == null) {
            LOGGER.warn("Could not find default flight recorder config at {}", (Object)FLIGHT_RECORDER_CONFIG);
            return false;
        }
        BufferedReader var2 = new BufferedReader(new InputStreamReader(var1.openStream()));
        try {
            bl = this.start(var2, var0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    var2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException var22) {
                LOGGER.warn("Failed to start flight recorder using configuration at {}", (Object)var1, (Object)var22);
                return false;
            }
        }
        var2.close();
        return bl;
    }

    @Override
    public Path stop() {
        if (this.recording == null) {
            throw new IllegalStateException("Not currently profiling");
        }
        this.networkTrafficByAddress.clear();
        Path var0 = this.recording.getDestination();
        this.recording.stop();
        return var0;
    }

    @Override
    public boolean isRunning() {
        return this.recording != null;
    }

    @Override
    public boolean isAvailable() {
        return FlightRecorder.isAvailable();
    }

    private boolean start(Reader var0, Environment var1) {
        if (this.isRunning()) {
            LOGGER.warn("Profiling already in progress");
            return false;
        }
        try {
            Configuration var22 = Configuration.create(var0);
            String var3 = DATE_TIME_FORMATTER.format(Instant.now());
            this.recording = SystemUtils.make(new Recording(var22), var2 -> {
                CUSTOM_EVENTS.forEach(var2::enable);
                var2.setDumpOnExit(true);
                var2.setToDisk(true);
                var2.setName("%s-%s-%s".formatted(var1.getDescription(), SharedConstants.getCurrentVersion().getName(), var3));
            });
            Path var4 = Paths.get("debug/%s-%s.jfr".formatted(var1.getDescription(), var3), new String[0]);
            if (!Files.exists(var4.getParent(), new LinkOption[0])) {
                Files.createDirectories(var4.getParent(), new FileAttribute[0]);
            }
            this.recording.setDestination(var4);
            this.recording.start();
            this.setupSummaryListener();
        }
        catch (IOException | ParseException var23) {
            LOGGER.warn("Failed to start jfr profiling", (Throwable)var23);
            return false;
        }
        LOGGER.info("Started flight recorder profiling id({}):name({}) - will dump to {} on exit or stop command", (Object)this.recording.getId(), (Object)this.recording.getName(), (Object)this.recording.getDestination());
        return true;
    }

    private void setupSummaryListener() {
        FlightRecorder.addListener(new FlightRecorderListener(){
            final SummaryReporter summaryReporter = new SummaryReporter(() -> {
                JfrProfiler.this.recording = null;
            });

            @Override
            public void recordingStateChanged(Recording var0) {
                if (var0 != JfrProfiler.this.recording || var0.getState() != RecordingState.STOPPED) {
                    return;
                }
                this.summaryReporter.recordingStopped(var0.getDestination());
                FlightRecorder.removeListener(this);
            }
        });
    }

    @Override
    public void onServerTick(float var0) {
        if (ServerTickTimeEvent.TYPE.isEnabled()) {
            this.currentAverageTickTime = var0;
        }
    }

    @Override
    public void onPacketReceived(int var0, int var1, SocketAddress var2, int var3) {
        if (PacketReceivedEvent.TYPE.isEnabled()) {
            new PacketReceivedEvent(var0, var1, var2, var3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.networkStatFor(var2).trackReceivedPacket(var3);
        }
    }

    @Override
    public void onPacketSent(int var0, int var1, SocketAddress var2, int var3) {
        if (PacketSentEvent.TYPE.isEnabled()) {
            new PacketSentEvent(var0, var1, var2, var3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.networkStatFor(var2).trackSentPacket(var3);
        }
    }

    private NetworkSummaryEvent.b networkStatFor(SocketAddress var0) {
        return this.networkTrafficByAddress.computeIfAbsent(var0.toString(), NetworkSummaryEvent.b::new);
    }

    @Override
    @Nullable
    public ProfiledDuration onWorldLoadedStarted() {
        if (!WorldLoadFinishedEvent.TYPE.isEnabled()) {
            return null;
        }
        WorldLoadFinishedEvent var0 = new WorldLoadFinishedEvent();
        var0.begin();
        return var0::commit;
    }

    @Override
    @Nullable
    public ProfiledDuration onChunkGenerate(ChunkCoordIntPair var0, ResourceKey<World> var1, String var2) {
        if (!ChunkGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        ChunkGenerationEvent var3 = new ChunkGenerationEvent(var0, var1, var2);
        var3.begin();
        return var3::commit;
    }
}

