/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.MethodProfilerResult;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MethodProfilerResultsFilled
implements MethodProfilerResults {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final MethodProfilerResult EMPTY = new MethodProfilerResult(){

        @Override
        public long getDuration() {
            return 0L;
        }

        @Override
        public long getMaxDuration() {
            return 0L;
        }

        @Override
        public long getCount() {
            return 0L;
        }

        @Override
        public Object2LongMap<String> getCounters() {
            return Object2LongMaps.emptyMap();
        }
    };
    private static final Splitter SPLITTER = Splitter.on((char)'\u001e');
    private static final Comparator<Map.Entry<String, a>> COUNTER_ENTRY_COMPARATOR = Map.Entry.comparingByValue(Comparator.comparingLong(var0 -> var0.totalValue)).reversed();
    private final Map<String, ? extends MethodProfilerResult> entries;
    private final long startTimeNano;
    private final int startTimeTicks;
    private final long endTimeNano;
    private final int endTimeTicks;
    private final int tickDuration;

    public MethodProfilerResultsFilled(Map<String, ? extends MethodProfilerResult> var0, long var1, int var3, long var4, int var6) {
        this.entries = var0;
        this.startTimeNano = var1;
        this.startTimeTicks = var3;
        this.endTimeNano = var4;
        this.endTimeTicks = var6;
        this.tickDuration = var6 - var3;
    }

    private MethodProfilerResult getEntry(String var0) {
        MethodProfilerResult var1 = this.entries.get(var0);
        return var1 != null ? var1 : EMPTY;
    }

    @Override
    public List<MethodProfilerResultsField> getTimes(String var0) {
        String var1 = var0;
        MethodProfilerResult var2 = this.getEntry("root");
        long var3 = var2.getDuration();
        MethodProfilerResult var5 = this.getEntry((String)var0);
        long var6 = var5.getDuration();
        long var8 = var5.getCount();
        ArrayList var10 = Lists.newArrayList();
        if (!((String)var0).isEmpty()) {
            var0 = (String)var0 + "\u001e";
        }
        long var11 = 0L;
        for (String var14 : this.entries.keySet()) {
            if (!MethodProfilerResultsFilled.isDirectChild((String)var0, var14)) continue;
            var11 += this.getEntry(var14).getDuration();
        }
        float var13 = var11;
        if (var11 < var6) {
            var11 = var6;
        }
        if (var3 < var11) {
            var3 = var11;
        }
        for (String var15 : this.entries.keySet()) {
            if (!MethodProfilerResultsFilled.isDirectChild((String)var0, var15)) continue;
            MethodProfilerResult var16 = this.getEntry(var15);
            long var17 = var16.getDuration();
            double var19 = (double)var17 * 100.0 / (double)var11;
            double var21 = (double)var17 * 100.0 / (double)var3;
            String var23 = var15.substring(((String)var0).length());
            var10.add(new MethodProfilerResultsField(var23, var19, var21, var16.getCount()));
        }
        if ((float)var11 > var13) {
            var10.add(new MethodProfilerResultsField("unspecified", (double)((float)var11 - var13) * 100.0 / (double)var11, (double)((float)var11 - var13) * 100.0 / (double)var3, var8));
        }
        Collections.sort(var10);
        var10.add(0, new MethodProfilerResultsField(var1, 100.0, (double)var11 * 100.0 / (double)var3, var8));
        return var10;
    }

    private static boolean isDirectChild(String var0, String var1) {
        return var1.length() > var0.length() && var1.startsWith(var0) && var1.indexOf(30, var0.length() + 1) < 0;
    }

    private Map<String, a> getCounterValues() {
        TreeMap var0 = Maps.newTreeMap();
        this.entries.forEach((var1, var22) -> {
            Object2LongMap<String> var32 = var22.getCounters();
            if (!var32.isEmpty()) {
                List var4 = SPLITTER.splitToList((CharSequence)var1);
                var32.forEach((var2, var3) -> var0.computeIfAbsent(var2, var0 -> new a()).addValue(var4.iterator(), (long)var3));
            }
        });
        return var0;
    }

    @Override
    public long getStartTimeNano() {
        return this.startTimeNano;
    }

    @Override
    public int getStartTimeTicks() {
        return this.startTimeTicks;
    }

    @Override
    public long getEndTimeNano() {
        return this.endTimeNano;
    }

    @Override
    public int getEndTimeTicks() {
        return this.endTimeTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveResults(Path var0) {
        boolean bl;
        BufferedWriter var1 = null;
        try {
            Files.createDirectories(var0.getParent(), new FileAttribute[0]);
            var1 = Files.newBufferedWriter(var0, StandardCharsets.UTF_8, new OpenOption[0]);
            var1.write(this.getProfilerResults(this.getNanoDuration(), this.getTickDuration()));
            bl = true;
        }
        catch (Throwable var2) {
            boolean bl2;
            try {
                LOGGER.error("Could not save profiler results to {}", (Object)var0, (Object)var2);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(var1);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)var1);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)var1);
        return bl;
    }

    protected String getProfilerResults(long var0, int var2) {
        StringBuilder var3 = new StringBuilder();
        var3.append("---- Minecraft Profiler Results ----\n");
        var3.append("// ");
        var3.append(MethodProfilerResultsFilled.getComment());
        var3.append("\n\n");
        var3.append("Version: ").append(SharedConstants.getCurrentVersion().getId()).append('\n');
        var3.append("Time span: ").append(var0 / 1000000L).append(" ms\n");
        var3.append("Tick span: ").append(var2).append(" ticks\n");
        var3.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var2 / ((float)var0 / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        var3.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.appendProfilerResults(0, "root", var3);
        var3.append("--- END PROFILE DUMP ---\n\n");
        Map<String, a> var4 = this.getCounterValues();
        if (!var4.isEmpty()) {
            var3.append("--- BEGIN COUNTER DUMP ---\n\n");
            this.appendCounters(var4, var3, var2);
            var3.append("--- END COUNTER DUMP ---\n\n");
        }
        return var3.toString();
    }

    @Override
    public String getProfilerResults() {
        StringBuilder var0 = new StringBuilder();
        this.appendProfilerResults(0, "root", var0);
        return var0.toString();
    }

    private static StringBuilder indentLine(StringBuilder var0, int var1) {
        var0.append(String.format("[%02d] ", var1));
        for (int var2 = 0; var2 < var1; ++var2) {
            var0.append("|   ");
        }
        return var0;
    }

    private void appendProfilerResults(int var0, String var1, StringBuilder var22) {
        List<MethodProfilerResultsField> var32 = this.getTimes(var1);
        Object2LongMap<String> var4 = ((MethodProfilerResult)ObjectUtils.firstNonNull((Object[])new MethodProfilerResult[]{this.entries.get(var1), EMPTY})).getCounters();
        var4.forEach((var2, var3) -> MethodProfilerResultsFilled.indentLine(var22, var0).append('#').append((String)var2).append(' ').append(var3).append('/').append(var3 / (long)this.tickDuration).append('\n'));
        if (var32.size() < 3) {
            return;
        }
        for (int var5 = 1; var5 < var32.size(); ++var5) {
            MethodProfilerResultsField var6 = var32.get(var5);
            MethodProfilerResultsFilled.indentLine(var22, var0).append(var6.name).append('(').append(var6.count).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)var6.count / (float)this.tickDuration))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", var6.percentage)).append("%/").append(String.format(Locale.ROOT, "%.2f", var6.globalPercentage)).append("%\n");
            if ("unspecified".equals(var6.name)) continue;
            try {
                this.appendProfilerResults(var0 + 1, var1 + "\u001e" + var6.name, var22);
                continue;
            }
            catch (Exception var7) {
                var22.append("[[ EXCEPTION ").append(var7).append(" ]]");
            }
        }
    }

    private void appendCounterResults(int var0, String var1, a var2, int var32, StringBuilder var4) {
        MethodProfilerResultsFilled.indentLine(var4, var0).append(var1).append(" total:").append(var2.selfValue).append('/').append(var2.totalValue).append(" average: ").append(var2.selfValue / (long)var32).append('/').append(var2.totalValue / (long)var32).append('\n');
        var2.children.entrySet().stream().sorted(COUNTER_ENTRY_COMPARATOR).forEach(var3 -> this.appendCounterResults(var0 + 1, (String)var3.getKey(), (a)var3.getValue(), var32, var4));
    }

    private void appendCounters(Map<String, a> var0, StringBuilder var1, int var22) {
        var0.forEach((var2, var3) -> {
            var1.append("-- Counter: ").append((String)var2).append(" --\n");
            this.appendCounterResults(0, "root", var3.children.get("root"), var22, var1);
            var1.append("\n\n");
        });
    }

    private static String getComment() {
        String[] var0 = new String[]{"I'd Rather Be Surfing", "Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return var0[(int)(SystemUtils.getNanos() % (long)var0.length)];
        }
        catch (Throwable var1) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    public int getTickDuration() {
        return this.tickDuration;
    }

    static class a {
        long selfValue;
        long totalValue;
        final Map<String, a> children = Maps.newHashMap();

        a() {
        }

        public void addValue(Iterator<String> var02, long var1) {
            this.totalValue += var1;
            if (!var02.hasNext()) {
                this.selfValue += var1;
            } else {
                this.children.computeIfAbsent(var02.next(), var0 -> new a()).addValue(var02, var1);
            }
        }
    }
}

