/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.lang.reflect.Type;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.StringUtils;

public class DataConverterSignText
extends DataConverterNamedEntity {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(IChatBaseComponent.class, (Object)new JsonDeserializer<IChatBaseComponent>(){

        public IChatMutableComponent deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            if (var0.isJsonPrimitive()) {
                return new ChatComponentText(var0.getAsString());
            }
            if (var0.isJsonArray()) {
                JsonArray var3 = var0.getAsJsonArray();
                IChatMutableComponent var4 = null;
                for (JsonElement var6 : var3) {
                    IChatMutableComponent var7 = this.deserialize(var6, var6.getClass(), var2);
                    if (var4 == null) {
                        var4 = var7;
                        continue;
                    }
                    var4.append(var7);
                }
                return var4;
            }
            throw new JsonParseException("Don't know how to turn " + var0 + " into a Component");
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }).create();

    public DataConverterSignText(Schema var0, boolean var1) {
        super(var0, var1, "BlockEntitySignTextStrictJsonFix", DataConverterTypes.BLOCK_ENTITY, "Sign");
    }

    private Dynamic<?> updateLine(Dynamic<?> var0, String var1) {
        String var2 = var0.get(var1).asString("");
        IChatBaseComponent var3 = null;
        if ("null".equals(var2) || StringUtils.isEmpty((CharSequence)var2)) {
            var3 = ChatComponentText.EMPTY;
        } else if (var2.charAt(0) == '\"' && var2.charAt(var2.length() - 1) == '\"' || var2.charAt(0) == '{' && var2.charAt(var2.length() - 1) == '}') {
            try {
                var3 = ChatDeserializer.fromJson(GSON, var2, IChatBaseComponent.class, true);
                if (var3 == null) {
                    var3 = ChatComponentText.EMPTY;
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
            if (var3 == null) {
                try {
                    var3 = IChatBaseComponent.ChatSerializer.fromJson(var2);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            if (var3 == null) {
                try {
                    var3 = IChatBaseComponent.ChatSerializer.fromJsonLenient(var2);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            if (var3 == null) {
                var3 = new ChatComponentText(var2);
            }
        } else {
            var3 = new ChatComponentText(var2);
        }
        return var0.set(var1, var0.createString(IChatBaseComponent.ChatSerializer.toJson(var3)));
    }

    @Override
    protected Typed<?> fix(Typed<?> var02) {
        return var02.update(DSL.remainderFinder(), var0 -> {
            var0 = this.updateLine((Dynamic<?>)var0, "Text1");
            var0 = this.updateLine((Dynamic<?>)var0, "Text2");
            var0 = this.updateLine((Dynamic<?>)var0, "Text3");
            var0 = this.updateLine((Dynamic<?>)var0, "Text4");
            return var0;
        });
    }
}

