/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterProtoChunk
extends DataFix {
    private static final int NUM_SECTIONS = 16;

    public DataConverterProtoChunk(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.CHUNK);
        Type var1 = this.getOutputSchema().getType(DataConverterTypes.CHUNK);
        Type var2 = var0.findFieldType("Level");
        Type var32 = var1.findFieldType("Level");
        Type var4 = var2.findFieldType("TileTicks");
        OpticFinder var5 = DSL.fieldFinder((String)"Level", (Type)var2);
        OpticFinder var6 = DSL.fieldFinder((String)"TileTicks", (Type)var4);
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("ChunkToProtoChunkFix", var0, this.getOutputSchema().getType(DataConverterTypes.CHUNK), var3 -> var3.updateTyped(var5, var32, var2 -> {
            Dynamic var6;
            Object var3 = var2.getOptionalTyped(var6).flatMap(var0 -> var0.write().result()).flatMap(var0 -> var0.asStreamOpt().result());
            Dynamic var4 = (Dynamic)var2.get(DSL.remainderFinder());
            boolean var5 = var4.get("TerrainPopulated").asBoolean(false) && (!var4.get("LightPopulated").asNumber().result().isPresent() || var4.get("LightPopulated").asBoolean(false));
            var4 = var4.set("Status", var4.createString(var5 ? "mobs_spawned" : "empty"));
            var4 = var4.set("hasLegacyStructureData", var4.createBoolean(true));
            if (var5) {
                Object var9;
                Object var8;
                Optional var7 = var4.get("Biomes").asByteBufferOpt().result();
                if (var7.isPresent()) {
                    var8 = (ByteBuffer)var7.get();
                    var9 = new int[256];
                    for (int var10 = 0; var10 < ((int[])var9).length; ++var10) {
                        if (var10 >= ((Buffer)var8).capacity()) continue;
                        var9[var10] = ((ByteBuffer)var8).get(var10) & 0xFF;
                    }
                    var4 = var4.set("Biomes", var4.createIntList(Arrays.stream((int[])var9)));
                }
                var8 = var4;
                var9 = IntStream.range(0, 16).mapToObj(var0 -> new ShortArrayList()).collect(Collectors.toList());
                if (var3.isPresent()) {
                    ((Stream)var3.get()).forEach(arg_0 -> DataConverterProtoChunk.a((List)var9, arg_0));
                    var4 = var4.set("ToBeTicked", var4.createList(var9.stream().map(arg_0 -> DataConverterProtoChunk.a((Dynamic)var8, arg_0))));
                }
                var6 = (Dynamic)DataFixUtils.orElse((Optional)var2.set(DSL.remainderFinder(), (Object)var4).write().result(), (Object)var4);
            } else {
                var6 = var4;
            }
            return (Typed)((Pair)var32.readTyped(var6).result().orElseThrow(() -> new IllegalStateException("Could not read the new chunk"))).getFirst();
        })), (TypeRewriteRule)this.writeAndRead("Structure biome inject", this.getInputSchema().getType(DataConverterTypes.STRUCTURE_FEATURE), this.getOutputSchema().getType(DataConverterTypes.STRUCTURE_FEATURE)));
    }

    private static short packOffsetCoordinates(int var0, int var1, int var2) {
        return (short)(var0 & 0xF | (var1 & 0xF) << 4 | (var2 & 0xF) << 8);
    }

    private static /* synthetic */ Dynamic a(Dynamic var0, ShortList var1) {
        return var0.createList(var1.stream().map(arg_0 -> ((Dynamic)var0).createShort(arg_0)));
    }

    private static /* synthetic */ void a(List var0, Dynamic var1) {
        int var2 = var1.get("x").asInt(0);
        int var3 = var1.get("y").asInt(0);
        int var4 = var1.get("z").asInt(0);
        short var5 = DataConverterProtoChunk.packOffsetCoordinates(var2, var3, var4);
        ((ShortList)var0.get(var3 >> 4)).add(var5);
    }
}

