/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.util.DebugBuffer;

public class ThreadingDetector {
    public static void checkAndLock(Semaphore var0, @Nullable DebugBuffer<Pair<Thread, StackTraceElement[]>> var1, String var2) {
        boolean var3 = var0.tryAcquire();
        if (!var3) {
            throw ThreadingDetector.makeThreadingException(var2, var1);
        }
    }

    public static ReportedException makeThreadingException(String var02, @Nullable DebugBuffer<Pair<Thread, StackTraceElement[]>> var1) {
        String var2 = Thread.getAllStackTraces().keySet().stream().filter(Objects::nonNull).map(var0 -> var0.getName() + ": \n\tat " + Arrays.stream(var0.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n\tat "))).collect(Collectors.joining("\n"));
        CrashReport var3 = new CrashReport("Accessing " + var02 + " from multiple threads", new IllegalStateException());
        CrashReportSystemDetails var4 = var3.addCategory("Thread dumps");
        var4.setDetail("Thread dumps", var2);
        if (var1 != null) {
            StringBuilder var5 = new StringBuilder();
            List<Pair<Thread, StackTraceElement[]>> var6 = var1.dump();
            for (Pair<Thread, StackTraceElement[]> var8 : var6) {
                var5.append("Thread ").append(((Thread)var8.getFirst()).getName()).append(": \n\tat ").append(Arrays.stream((StackTraceElement[])var8.getSecond()).map(Object::toString).collect(Collectors.joining("\n\tat "))).append("\n");
            }
            var4.setDetail("Last threads", var5.toString());
        }
        return new ReportedException(var3);
    }
}

