/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.DataBits;
import org.apache.commons.lang3.Validate;

public class SimpleBitStorage
implements DataBits {
    private static final int[] MAGIC = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final long[] data;
    private final int bits;
    private final long mask;
    private final int size;
    private final int valuesPerLong;
    private final int divideMul;
    private final int divideAdd;
    private final int divideShift;

    public SimpleBitStorage(int var0, int var1, int[] var2) {
        this(var0, var1);
        int var3;
        int var4 = 0;
        for (var3 = 0; var3 <= var1 - this.valuesPerLong; var3 += this.valuesPerLong) {
            long var5 = 0L;
            for (int var7 = this.valuesPerLong - 1; var7 >= 0; --var7) {
                var5 <<= var0;
                var5 |= (long)var2[var3 + var7] & this.mask;
            }
            this.data[var4++] = var5;
        }
        int var5 = var1 - var3;
        if (var5 > 0) {
            long var6 = 0L;
            for (int var8 = var5 - 1; var8 >= 0; --var8) {
                var6 <<= var0;
                var6 |= (long)var2[var3 + var8] & this.mask;
            }
            this.data[var4] = var6;
        }
    }

    public SimpleBitStorage(int var0, int var1) {
        this(var0, var1, (long[])null);
    }

    public SimpleBitStorage(int var0, int var1, @Nullable long[] var2) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)var0);
        this.size = var1;
        this.bits = var0;
        this.mask = (1L << var0) - 1L;
        this.valuesPerLong = (char)(64 / var0);
        int var3 = 3 * (this.valuesPerLong - 1);
        this.divideMul = MAGIC[var3 + 0];
        this.divideAdd = MAGIC[var3 + 1];
        this.divideShift = MAGIC[var3 + 2];
        int var4 = (var1 + this.valuesPerLong - 1) / this.valuesPerLong;
        if (var2 != null) {
            if (var2.length != var4) {
                throw new a("Invalid length given for storage, got: " + var2.length + " but expected: " + var4);
            }
            this.data = var2;
        } else {
            this.data = new long[var4];
        }
    }

    private int cellIndex(int var0) {
        long var1 = Integer.toUnsignedLong(this.divideMul);
        long var3 = Integer.toUnsignedLong(this.divideAdd);
        return (int)((long)var0 * var1 + var3 >> 32 >> this.divideShift);
    }

    @Override
    public int getAndSet(int var0, int var1) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)var0);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)var1);
        int var2 = this.cellIndex(var0);
        long var3 = this.data[var2];
        int var5 = (var0 - var2 * this.valuesPerLong) * this.bits;
        int var6 = (int)(var3 >> var5 & this.mask);
        this.data[var2] = var3 & (this.mask << var5 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)var1 & this.mask) << var5;
        return var6;
    }

    @Override
    public void set(int var0, int var1) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)var0);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)var1);
        int var2 = this.cellIndex(var0);
        long var3 = this.data[var2];
        int var5 = (var0 - var2 * this.valuesPerLong) * this.bits;
        this.data[var2] = var3 & (this.mask << var5 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)var1 & this.mask) << var5;
    }

    @Override
    public int get(int var0) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)var0);
        int var1 = this.cellIndex(var0);
        long var2 = this.data[var1];
        int var4 = (var0 - var1 * this.valuesPerLong) * this.bits;
        return (int)(var2 >> var4 & this.mask);
    }

    @Override
    public long[] getRaw() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public void getAll(IntConsumer var0) {
        int var1 = 0;
        for (long var5 : this.data) {
            for (int var7 = 0; var7 < this.valuesPerLong; ++var7) {
                var0.accept((int)(var5 & this.mask));
                var5 >>= this.bits;
                if (++var1 < this.size) continue;
                return;
            }
        }
    }

    @Override
    public void unpack(int[] var0) {
        int var6;
        long var4;
        int var3;
        int var1 = this.data.length;
        int var2 = 0;
        for (var3 = 0; var3 < var1 - 1; ++var3) {
            var4 = this.data[var3];
            for (var6 = 0; var6 < this.valuesPerLong; ++var6) {
                var0[var2 + var6] = (int)(var4 & this.mask);
                var4 >>= this.bits;
            }
            var2 += this.valuesPerLong;
        }
        var3 = this.size - var2;
        if (var3 > 0) {
            var4 = this.data[var1 - 1];
            for (var6 = 0; var6 < var3; ++var6) {
                var0[var2 + var6] = (int)(var4 & this.mask);
                var4 >>= this.bits;
            }
        }
    }

    public static class a
    extends RuntimeException {
        a(String var0) {
            super(var0);
        }
    }
}

