/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;

public record InclusiveRange(T minInclusive, T maxInclusive) {
    public static final Codec<InclusiveRange<Integer>> INT = InclusiveRange.codec(Codec.INT);

    public InclusiveRange {
        if (var0.compareTo(var1) > 0) {
            throw new IllegalArgumentException("min_inclusive must be less than or equal to max_inclusive");
        }
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> codec(Codec<T> var0) {
        return ExtraCodecs.intervalCodec(var0, "min_inclusive", "max_inclusive", InclusiveRange::create, InclusiveRange::minInclusive, InclusiveRange::maxInclusive);
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> codec(Codec<T> var0, T var1, T var22) {
        Function<InclusiveRange, DataResult> var3 = var2 -> {
            if (var2.minInclusive().compareTo(var1) < 0) {
                return DataResult.error((String)("Range limit too low, expected at least " + var1 + " [" + var2.minInclusive() + "-" + var2.maxInclusive() + "]"));
            }
            if (var2.maxInclusive().compareTo(var22) > 0) {
                return DataResult.error((String)("Range limit too high, expected at most " + var22 + " [" + var2.minInclusive() + "-" + var2.maxInclusive() + "]"));
            }
            return DataResult.success((Object)var2);
        };
        return InclusiveRange.codec(var0).flatXmap(var3, var3);
    }

    public static <T extends Comparable<T>> DataResult<InclusiveRange<T>> create(T var0, T var1) {
        if (var0.compareTo(var1) <= 0) {
            return DataResult.success((Object)new InclusiveRange(var0, var1));
        }
        return DataResult.error((String)"min_inclusive must be less than or equal to max_inclusive");
    }

    public boolean isValueInRange(T var0) {
        return var0.compareTo(this.minInclusive) >= 0 && var0.compareTo(this.maxInclusive) <= 0;
    }

    public boolean contains(InclusiveRange<T> var0) {
        return var0.minInclusive().compareTo(this.minInclusive) >= 0 && var0.maxInclusive.compareTo(this.maxInclusive) <= 0;
    }

    @Override
    public String toString() {
        return "[" + this.minInclusive + ", " + this.maxInclusive + "]";
    }
}

