/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

public class CircularTimer {
    public static final int LOGGING_LENGTH = 240;
    private final long[] loggedTimes = new long[240];
    private int logStart;
    private int logLength;
    private int logEnd;

    public void logFrameDuration(long var0) {
        this.loggedTimes[this.logEnd] = var0;
        ++this.logEnd;
        if (this.logEnd == 240) {
            this.logEnd = 0;
        }
        if (this.logLength < 240) {
            this.logStart = 0;
            ++this.logLength;
        } else {
            this.logStart = this.wrapIndex(this.logEnd + 1);
        }
    }

    public long getAverageDuration(int var0) {
        int var1 = (this.logStart + var0) % 240;
        long var3 = 0L;
        for (int var2 = this.logStart; var2 != var1; ++var2) {
            var3 += this.loggedTimes[var2];
        }
        return var3 / (long)var0;
    }

    public int scaleAverageDurationTo(int var0, int var1) {
        return this.scaleSampleTo(this.getAverageDuration(var0), var1, 60);
    }

    public int scaleSampleTo(long var0, int var2, int var3) {
        double var4 = (double)var0 / (double)(1000000000L / (long)var3);
        return (int)(var4 * (double)var2);
    }

    public int getLogStart() {
        return this.logStart;
    }

    public int getLogEnd() {
        return this.logEnd;
    }

    public int wrapIndex(int var0) {
        return var0 % 240;
    }

    public long[] getLog() {
        return this.loggedTimes;
    }
}

