/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagSet;

public interface Tags<T> {
    public Map<MinecraftKey, Tag<T>> getAllTags();

    @Nullable
    default public Tag<T> getTag(MinecraftKey var0) {
        return this.getAllTags().get(var0);
    }

    public Tag<T> getTagOrEmpty(MinecraftKey var1);

    @Nullable
    default public MinecraftKey getId(Tag.e<T> var0) {
        return var0.getName();
    }

    @Nullable
    public MinecraftKey getId(Tag<T> var1);

    default public boolean hasTag(MinecraftKey var0) {
        return this.getAllTags().containsKey(var0);
    }

    default public Collection<MinecraftKey> getAvailableTags() {
        return this.getAllTags().keySet();
    }

    default public Collection<MinecraftKey> getMatchingTags(T var0) {
        ArrayList var1 = Lists.newArrayList();
        for (Map.Entry<MinecraftKey, Tag<T>> var3 : this.getAllTags().entrySet()) {
            if (!var3.getValue().contains(var0)) continue;
            var1.add(var3.getKey());
        }
        return var1;
    }

    default public a serializeToNetwork(IRegistry<T> var0) {
        Map<MinecraftKey, Tag<T>> var1 = this.getAllTags();
        HashMap var22 = Maps.newHashMapWithExpectedSize((int)var1.size());
        var1.forEach((var2, var3) -> {
            List var4 = var3.getValues();
            IntArrayList var5 = new IntArrayList(var4.size());
            for (Object var7 : var4) {
                var5.add(var0.getId(var7));
            }
            var22.put(var2, var5);
        });
        return new a(var22);
    }

    public static <T> Tags<T> createFromNetwork(a var0, IRegistry<? extends T> var1) {
        HashMap var22 = Maps.newHashMapWithExpectedSize((int)var0.tags.size());
        var0.tags.forEach((var2, var3) -> {
            ImmutableSet.Builder var4 = ImmutableSet.builder();
            IntListIterator intListIterator = var3.iterator();
            while (intListIterator.hasNext()) {
                int var6 = (Integer)intListIterator.next();
                var4.add(var1.byId(var6));
            }
            var22.put(var2, Tag.fromSet(var4.build()));
        });
        return Tags.of(var22);
    }

    public static <T> Tags<T> empty() {
        return Tags.of(ImmutableBiMap.of());
    }

    public static <T> Tags<T> of(Map<MinecraftKey, Tag<T>> var0) {
        ImmutableBiMap var1 = ImmutableBiMap.copyOf(var0);
        return new Tags<T>((BiMap)var1){
            private final Tag<T> empty = TagSet.empty();
            final /* synthetic */ BiMap a;
            {
                this.a = biMap;
            }

            @Override
            public Tag<T> getTagOrEmpty(MinecraftKey var0) {
                return (Tag)this.a.getOrDefault((Object)var0, this.empty);
            }

            @Override
            @Nullable
            public MinecraftKey getId(Tag<T> var0) {
                if (var0 instanceof Tag.e) {
                    return ((Tag.e)var0).getName();
                }
                return (MinecraftKey)this.a.inverse().get(var0);
            }

            @Override
            public Map<MinecraftKey, Tag<T>> getAllTags() {
                return this.a;
            }
        };
    }

    public static class a {
        final Map<MinecraftKey, IntList> tags;

        a(Map<MinecraftKey, IntList> var0) {
            this.tags = var0;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeMap(this.tags, PacketDataSerializer::writeResourceLocation, PacketDataSerializer::writeIntIdList);
        }

        public static a read(PacketDataSerializer var0) {
            return new a(var0.readMap(PacketDataSerializer::readResourceLocation, PacketDataSerializer::readIntIdList));
        }
    }
}

