/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagSet;
import net.minecraft.tags.Tags;

public class TagUtil<T> {
    private final ResourceKey<? extends IRegistry<T>> key;
    private final String directory;
    private Tags<T> source = Tags.empty();
    private final List<a<T>> wrappers = Lists.newArrayList();

    public TagUtil(ResourceKey<? extends IRegistry<T>> var0, String var1) {
        this.key = var0;
        this.directory = var1;
    }

    public Tag.e<T> bind(String var0) {
        a var1 = new a(new MinecraftKey(var0));
        this.wrappers.add(var1);
        return var1;
    }

    public void resetToEmpty() {
        this.source = Tags.empty();
        TagSet var0 = TagSet.empty();
        this.wrappers.forEach(var12 -> var12.rebind(var1 -> var0));
    }

    public void reset(ITagRegistry var0) {
        Tags var12 = var0.getOrEmpty(this.key);
        this.source = var12;
        this.wrappers.forEach(var1 -> var1.rebind(var12::getTag));
    }

    public Tags<T> getAllTags() {
        return this.source;
    }

    public Set<MinecraftKey> getMissingTags(ITagRegistry var0) {
        Tags var1 = var0.getOrEmpty(this.key);
        Set var2 = this.wrappers.stream().map(a::getName).collect(Collectors.toSet());
        ImmutableSet var3 = ImmutableSet.copyOf(var1.getAvailableTags());
        return Sets.difference(var2, (Set)var3);
    }

    public ResourceKey<? extends IRegistry<T>> getKey() {
        return this.key;
    }

    public String getDirectory() {
        return this.directory;
    }

    protected void addToCollection(ITagRegistry.a var02) {
        var02.add(this.key, Tags.of(this.wrappers.stream().collect(Collectors.toMap(Tag.e::getName, var0 -> var0))));
    }

    static class a<T>
    implements Tag.e<T> {
        @Nullable
        private Tag<T> tag;
        protected final MinecraftKey name;

        a(MinecraftKey var0) {
            this.name = var0;
        }

        @Override
        public MinecraftKey getName() {
            return this.name;
        }

        private Tag<T> resolve() {
            if (this.tag == null) {
                throw new IllegalStateException("Tag " + this.name + " used before it was bound");
            }
            return this.tag;
        }

        void rebind(Function<MinecraftKey, Tag<T>> var0) {
            this.tag = var0.apply(this.name);
        }

        @Override
        public boolean contains(T var0) {
            return this.resolve().contains(var0);
        }

        @Override
        public List<T> getValues() {
            return this.resolve().getValues();
        }
    }
}

