/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.tags.TagUtil;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;

public class TagStatic {
    private static final Set<ResourceKey<?>> HELPERS_IDS = Sets.newHashSet();
    private static final List<TagUtil<?>> HELPERS = Lists.newArrayList();

    public static <T> TagUtil<T> create(ResourceKey<? extends IRegistry<T>> var0, String var1) {
        if (!HELPERS_IDS.add(var0)) {
            throw new IllegalStateException("Duplicate entry for static tag collection: " + var0);
        }
        TagUtil var2 = new TagUtil(var0, var1);
        HELPERS.add(var2);
        return var2;
    }

    public static void resetAll(ITagRegistry var0) {
        HELPERS.forEach(var1 -> var1.reset(var0));
    }

    public static void resetAllToEmpty() {
        HELPERS.forEach(TagUtil::resetToEmpty);
    }

    public static Multimap<ResourceKey<? extends IRegistry<?>>, MinecraftKey> getAllMissingTags(ITagRegistry var0) {
        HashMultimap var1 = HashMultimap.create();
        HELPERS.forEach(arg_0 -> TagStatic.a((Multimap)var1, var0, arg_0));
        return var1;
    }

    public static void bootStrap() {
        TagStatic.makeSureAllKnownHelpersAreLoaded();
    }

    private static Set<TagUtil<?>> getAllKnownHelpers() {
        return ImmutableSet.of(TagsBlock.HELPER, TagsItem.HELPER, TagsFluid.HELPER, TagsEntity.HELPER, GameEventTags.HELPER);
    }

    private static void makeSureAllKnownHelpersAreLoaded() {
        Set var0 = TagStatic.getAllKnownHelpers().stream().map(TagUtil::getKey).collect(Collectors.toSet());
        if (!Sets.difference(HELPERS_IDS, var0).isEmpty()) {
            throw new IllegalStateException("Missing helper registrations");
        }
    }

    public static void visitHelpers(Consumer<TagUtil<?>> var0) {
        HELPERS.forEach(var0);
    }

    public static ITagRegistry createCollection() {
        ITagRegistry.a var0 = new ITagRegistry.a();
        TagStatic.makeSureAllKnownHelpersAreLoaded();
        HELPERS.forEach(var1 -> var1.addToCollection(var0));
        return var0.build();
    }

    private static /* synthetic */ void a(Multimap var0, ITagRegistry var1, TagUtil var2) {
        var0.putAll(var2.getKey(), var2.getMissingTags(var1));
    }
}

