/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagSet;
import net.minecraft.tags.Tags;
import net.minecraft.util.ChatDeserializer;

public interface Tag<T> {
    public static <T> Codec<Tag<T>> codec(Supplier<Tags<T>> var0) {
        return MinecraftKey.CODEC.flatXmap(var1 -> Optional.ofNullable(((Tags)var0.get()).getTag((MinecraftKey)var1)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + var1))), var1 -> Optional.ofNullable(((Tags)var0.get()).getId(var1)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + var1))));
    }

    public boolean contains(T var1);

    public List<T> getValues();

    default public T getRandomElement(Random var0) {
        List<T> var1 = this.getValues();
        return var1.get(var0.nextInt(var1.size()));
    }

    public static <T> Tag<T> fromSet(Set<T> var0) {
        return TagSet.create(var0);
    }

    public static interface e<T>
    extends Tag<T> {
        public MinecraftKey getName();
    }

    public static class g
    implements d {
        private final MinecraftKey id;

        public g(MinecraftKey var0) {
            this.id = var0;
        }

        @Override
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1, Consumer<T> var2) {
            Tag<T> var3 = var0.apply(this.id);
            if (var3 != null) {
                var3.getValues().forEach(var2);
            }
            return true;
        }

        @Override
        public void serializeTo(JsonArray var0) {
            JsonObject var1 = new JsonObject();
            var1.addProperty("id", "#" + this.id);
            var1.addProperty("required", Boolean.valueOf(false));
            var0.add((JsonElement)var1);
        }

        public String toString() {
            return "#" + this.id + "?";
        }

        @Override
        public void visitOptionalDependencies(Consumer<MinecraftKey> var0) {
            var0.accept(this.id);
        }

        @Override
        public boolean verifyIfPresent(Predicate<MinecraftKey> var0, Predicate<MinecraftKey> var1) {
            return true;
        }
    }

    public static class h
    implements d {
        private final MinecraftKey id;

        public h(MinecraftKey var0) {
            this.id = var0;
        }

        @Override
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1, Consumer<T> var2) {
            Tag<T> var3 = var0.apply(this.id);
            if (var3 == null) {
                return false;
            }
            var3.getValues().forEach(var2);
            return true;
        }

        @Override
        public void serializeTo(JsonArray var0) {
            var0.add("#" + this.id);
        }

        public String toString() {
            return "#" + this.id;
        }

        @Override
        public boolean verifyIfPresent(Predicate<MinecraftKey> var0, Predicate<MinecraftKey> var1) {
            return var1.test(this.id);
        }

        @Override
        public void visitRequiredDependencies(Consumer<MinecraftKey> var0) {
            var0.accept(this.id);
        }
    }

    public static class f
    implements d {
        private final MinecraftKey id;

        public f(MinecraftKey var0) {
            this.id = var0;
        }

        @Override
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1, Consumer<T> var2) {
            T var3 = var1.apply(this.id);
            if (var3 != null) {
                var2.accept(var3);
            }
            return true;
        }

        @Override
        public void serializeTo(JsonArray var0) {
            JsonObject var1 = new JsonObject();
            var1.addProperty("id", this.id.toString());
            var1.addProperty("required", Boolean.valueOf(false));
            var0.add((JsonElement)var1);
        }

        @Override
        public boolean verifyIfPresent(Predicate<MinecraftKey> var0, Predicate<MinecraftKey> var1) {
            return true;
        }

        public String toString() {
            return this.id + "?";
        }
    }

    public static class c
    implements d {
        private final MinecraftKey id;

        public c(MinecraftKey var0) {
            this.id = var0;
        }

        @Override
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1, Consumer<T> var2) {
            T var3 = var1.apply(this.id);
            if (var3 == null) {
                return false;
            }
            var2.accept(var3);
            return true;
        }

        @Override
        public void serializeTo(JsonArray var0) {
            var0.add(this.id.toString());
        }

        @Override
        public boolean verifyIfPresent(Predicate<MinecraftKey> var0, Predicate<MinecraftKey> var1) {
            return var0.test(this.id);
        }

        public String toString() {
            return this.id.toString();
        }
    }

    public static interface d {
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var1, Function<MinecraftKey, T> var2, Consumer<T> var3);

        public void serializeTo(JsonArray var1);

        default public void visitRequiredDependencies(Consumer<MinecraftKey> var0) {
        }

        default public void visitOptionalDependencies(Consumer<MinecraftKey> var0) {
        }

        public boolean verifyIfPresent(Predicate<MinecraftKey> var1, Predicate<MinecraftKey> var2);
    }

    public static class a {
        private final List<b> entries = Lists.newArrayList();

        public static a tag() {
            return new a();
        }

        public a add(b var0) {
            this.entries.add(var0);
            return this;
        }

        public a add(d var0, String var1) {
            return this.add(new b(var0, var1));
        }

        public a addElement(MinecraftKey var0, String var1) {
            return this.add(new c(var0), var1);
        }

        public a addOptionalElement(MinecraftKey var0, String var1) {
            return this.add(new f(var0), var1);
        }

        public a addTag(MinecraftKey var0, String var1) {
            return this.add(new h(var0), var1);
        }

        public a addOptionalTag(MinecraftKey var0, String var1) {
            return this.add(new g(var0), var1);
        }

        public <T> Either<Collection<b>, Tag<T>> build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1) {
            ImmutableSet.Builder var2 = ImmutableSet.builder();
            ArrayList var3 = Lists.newArrayList();
            for (b var5 : this.entries) {
                if (var5.getEntry().build(var0, var1, arg_0 -> ((ImmutableSet.Builder)var2).add(arg_0))) continue;
                var3.add(var5);
            }
            return var3.isEmpty() ? Either.right(Tag.fromSet(var2.build())) : Either.left((Object)var3);
        }

        public Stream<b> getEntries() {
            return this.entries.stream();
        }

        public void visitRequiredDependencies(Consumer<MinecraftKey> var0) {
            this.entries.forEach(var1 -> var1.entry.visitRequiredDependencies(var0));
        }

        public void visitOptionalDependencies(Consumer<MinecraftKey> var0) {
            this.entries.forEach(var1 -> var1.entry.visitOptionalDependencies(var0));
        }

        public a addFromJson(JsonObject var0, String var12) {
            JsonArray var2 = ChatDeserializer.getAsJsonArray(var0, "values");
            ArrayList var3 = Lists.newArrayList();
            for (JsonElement var5 : var2) {
                var3.add(a.parseEntry(var5));
            }
            if (ChatDeserializer.getAsBoolean(var0, "replace", false)) {
                this.entries.clear();
            }
            var3.forEach(var1 -> this.entries.add(new b((d)var1, var12)));
            return this;
        }

        private static d parseEntry(JsonElement var0) {
            boolean var2;
            String var1;
            Object var3;
            if (var0.isJsonObject()) {
                var3 = var0.getAsJsonObject();
                var1 = ChatDeserializer.getAsString(var3, "id");
                var2 = ChatDeserializer.getAsBoolean(var3, "required", true);
            } else {
                var1 = ChatDeserializer.convertToString(var0, "id");
                var2 = true;
            }
            if (var1.startsWith("#")) {
                var3 = new MinecraftKey(var1.substring(1));
                return var2 ? new h((MinecraftKey)var3) : new g((MinecraftKey)var3);
            }
            var3 = new MinecraftKey(var1);
            return var2 ? new c((MinecraftKey)var3) : new f((MinecraftKey)var3);
        }

        public JsonObject serializeToJson() {
            JsonObject var0 = new JsonObject();
            JsonArray var1 = new JsonArray();
            for (b var3 : this.entries) {
                var3.getEntry().serializeTo(var1);
            }
            var0.addProperty("replace", Boolean.valueOf(false));
            var0.add("values", (JsonElement)var1);
            return var0;
        }
    }

    public static class b {
        final d entry;
        private final String source;

        b(d var0, String var1) {
            this.entry = var0;
            this.source = var1;
        }

        public d getEntry() {
            return this.entry;
        }

        public String getSource() {
            return this.source;
        }

        public String toString() {
            return this.entry + " (from " + this.source + ")";
        }
    }
}

