/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagStatic;
import net.minecraft.tags.Tags;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ITagRegistry {
    static final Logger LOGGER = LogManager.getLogger();
    public static final ITagRegistry EMPTY = new ITagRegistry((Map<ResourceKey<? extends IRegistry<?>>, Tags<?>>)ImmutableMap.of());
    private final Map<ResourceKey<? extends IRegistry<?>>, Tags<?>> collections;

    ITagRegistry(Map<ResourceKey<? extends IRegistry<?>>, Tags<?>> var0) {
        this.collections = var0;
    }

    @Nullable
    private <T> Tags<T> get(ResourceKey<? extends IRegistry<T>> var0) {
        return this.collections.get(var0);
    }

    public <T> Tags<T> getOrEmpty(ResourceKey<? extends IRegistry<T>> var0) {
        return this.collections.getOrDefault(var0, Tags.empty());
    }

    public <T, E extends Exception> Tag<T> getTagOrThrow(ResourceKey<? extends IRegistry<T>> var0, MinecraftKey var1, Function<MinecraftKey, E> var2) throws E {
        Tags<T> var3 = this.get(var0);
        if (var3 == null) {
            throw (Exception)var2.apply(var1);
        }
        Tag<T> var4 = var3.getTag(var1);
        if (var4 == null) {
            throw (Exception)var2.apply(var1);
        }
        return var4;
    }

    public <T, E extends Exception> MinecraftKey getIdOrThrow(ResourceKey<? extends IRegistry<T>> var0, Tag<T> var1, Supplier<E> var2) throws E {
        Tags<T> var3 = this.get(var0);
        if (var3 == null) {
            throw (Exception)var2.get();
        }
        MinecraftKey var4 = var3.getId(var1);
        if (var4 == null) {
            throw (Exception)var2.get();
        }
        return var4;
    }

    public void getAll(b var0) {
        this.collections.forEach((var1, var2) -> ITagRegistry.acceptCap(var0, var1, var2));
    }

    private static <T> void acceptCap(b var0, ResourceKey<? extends IRegistry<?>> var1, Tags<?> var2) {
        var0.accept(var1, var2);
    }

    public void bindToGlobal() {
        TagStatic.resetAll(this);
        Blocks.rebuildCache();
    }

    public Map<ResourceKey<? extends IRegistry<?>>, Tags.a> serializeToNetwork(final IRegistryCustom var0) {
        final HashMap var1 = Maps.newHashMap();
        this.getAll(new b(){

            @Override
            public <T> void accept(ResourceKey<? extends IRegistry<T>> var02, Tags<T> var12) {
                Optional var2 = var0.registry(var02);
                if (var2.isPresent()) {
                    var1.put(var02, var12.serializeToNetwork(var2.get()));
                } else {
                    LOGGER.error("Unknown registry {}", var02);
                }
            }
        });
        return var1;
    }

    public static ITagRegistry deserializeFromNetwork(IRegistryCustom var0, Map<ResourceKey<? extends IRegistry<?>>, Tags.a> var1) {
        a var22 = new a();
        var1.forEach((var2, var3) -> ITagRegistry.addTagsFromPayload(var0, var22, var2, var3));
        return var22.build();
    }

    private static <T> void addTagsFromPayload(IRegistryCustom var0, a var1, ResourceKey<? extends IRegistry<? extends T>> var2, Tags.a var3) {
        Optional var4 = var0.registry(var2);
        if (var4.isPresent()) {
            var1.add(var2, Tags.createFromNetwork(var3, var4.get()));
        } else {
            LOGGER.error("Unknown registry {}", var2);
        }
    }

    @FunctionalInterface
    static interface b {
        public <T> void accept(ResourceKey<? extends IRegistry<T>> var1, Tags<T> var2);
    }

    public static class a {
        private final ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, Tags<?>> result = ImmutableMap.builder();

        public <T> a add(ResourceKey<? extends IRegistry<? extends T>> var0, Tags<T> var1) {
            this.result.put(var0, var1);
            return this;
        }

        public ITagRegistry build() {
            return new ITagRegistry((Map<ResourceKey<? extends IRegistry<?>>, Tags<?>>)this.result.build());
        }
    }
}

