/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.Counter;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class StatisticList {
    public static final StatisticWrapper<Block> BLOCK_MINED = StatisticList.makeRegistryStatType("mined", IRegistry.BLOCK);
    public static final StatisticWrapper<Item> ITEM_CRAFTED = StatisticList.makeRegistryStatType("crafted", IRegistry.ITEM);
    public static final StatisticWrapper<Item> ITEM_USED = StatisticList.makeRegistryStatType("used", IRegistry.ITEM);
    public static final StatisticWrapper<Item> ITEM_BROKEN = StatisticList.makeRegistryStatType("broken", IRegistry.ITEM);
    public static final StatisticWrapper<Item> ITEM_PICKED_UP = StatisticList.makeRegistryStatType("picked_up", IRegistry.ITEM);
    public static final StatisticWrapper<Item> ITEM_DROPPED = StatisticList.makeRegistryStatType("dropped", IRegistry.ITEM);
    public static final StatisticWrapper<EntityTypes<?>> ENTITY_KILLED = StatisticList.makeRegistryStatType("killed", IRegistry.ENTITY_TYPE);
    public static final StatisticWrapper<EntityTypes<?>> ENTITY_KILLED_BY = StatisticList.makeRegistryStatType("killed_by", IRegistry.ENTITY_TYPE);
    public static final StatisticWrapper<MinecraftKey> CUSTOM = StatisticList.makeRegistryStatType("custom", IRegistry.CUSTOM_STAT);
    public static final MinecraftKey LEAVE_GAME = StatisticList.makeCustomStat("leave_game", Counter.DEFAULT);
    public static final MinecraftKey PLAY_TIME = StatisticList.makeCustomStat("play_time", Counter.TIME);
    public static final MinecraftKey TOTAL_WORLD_TIME = StatisticList.makeCustomStat("total_world_time", Counter.TIME);
    public static final MinecraftKey TIME_SINCE_DEATH = StatisticList.makeCustomStat("time_since_death", Counter.TIME);
    public static final MinecraftKey TIME_SINCE_REST = StatisticList.makeCustomStat("time_since_rest", Counter.TIME);
    public static final MinecraftKey CROUCH_TIME = StatisticList.makeCustomStat("sneak_time", Counter.TIME);
    public static final MinecraftKey WALK_ONE_CM = StatisticList.makeCustomStat("walk_one_cm", Counter.DISTANCE);
    public static final MinecraftKey CROUCH_ONE_CM = StatisticList.makeCustomStat("crouch_one_cm", Counter.DISTANCE);
    public static final MinecraftKey SPRINT_ONE_CM = StatisticList.makeCustomStat("sprint_one_cm", Counter.DISTANCE);
    public static final MinecraftKey WALK_ON_WATER_ONE_CM = StatisticList.makeCustomStat("walk_on_water_one_cm", Counter.DISTANCE);
    public static final MinecraftKey FALL_ONE_CM = StatisticList.makeCustomStat("fall_one_cm", Counter.DISTANCE);
    public static final MinecraftKey CLIMB_ONE_CM = StatisticList.makeCustomStat("climb_one_cm", Counter.DISTANCE);
    public static final MinecraftKey FLY_ONE_CM = StatisticList.makeCustomStat("fly_one_cm", Counter.DISTANCE);
    public static final MinecraftKey WALK_UNDER_WATER_ONE_CM = StatisticList.makeCustomStat("walk_under_water_one_cm", Counter.DISTANCE);
    public static final MinecraftKey MINECART_ONE_CM = StatisticList.makeCustomStat("minecart_one_cm", Counter.DISTANCE);
    public static final MinecraftKey BOAT_ONE_CM = StatisticList.makeCustomStat("boat_one_cm", Counter.DISTANCE);
    public static final MinecraftKey PIG_ONE_CM = StatisticList.makeCustomStat("pig_one_cm", Counter.DISTANCE);
    public static final MinecraftKey HORSE_ONE_CM = StatisticList.makeCustomStat("horse_one_cm", Counter.DISTANCE);
    public static final MinecraftKey AVIATE_ONE_CM = StatisticList.makeCustomStat("aviate_one_cm", Counter.DISTANCE);
    public static final MinecraftKey SWIM_ONE_CM = StatisticList.makeCustomStat("swim_one_cm", Counter.DISTANCE);
    public static final MinecraftKey STRIDER_ONE_CM = StatisticList.makeCustomStat("strider_one_cm", Counter.DISTANCE);
    public static final MinecraftKey JUMP = StatisticList.makeCustomStat("jump", Counter.DEFAULT);
    public static final MinecraftKey DROP = StatisticList.makeCustomStat("drop", Counter.DEFAULT);
    public static final MinecraftKey DAMAGE_DEALT = StatisticList.makeCustomStat("damage_dealt", Counter.DIVIDE_BY_TEN);
    public static final MinecraftKey DAMAGE_DEALT_ABSORBED = StatisticList.makeCustomStat("damage_dealt_absorbed", Counter.DIVIDE_BY_TEN);
    public static final MinecraftKey DAMAGE_DEALT_RESISTED = StatisticList.makeCustomStat("damage_dealt_resisted", Counter.DIVIDE_BY_TEN);
    public static final MinecraftKey DAMAGE_TAKEN = StatisticList.makeCustomStat("damage_taken", Counter.DIVIDE_BY_TEN);
    public static final MinecraftKey DAMAGE_BLOCKED_BY_SHIELD = StatisticList.makeCustomStat("damage_blocked_by_shield", Counter.DIVIDE_BY_TEN);
    public static final MinecraftKey DAMAGE_ABSORBED = StatisticList.makeCustomStat("damage_absorbed", Counter.DIVIDE_BY_TEN);
    public static final MinecraftKey DAMAGE_RESISTED = StatisticList.makeCustomStat("damage_resisted", Counter.DIVIDE_BY_TEN);
    public static final MinecraftKey DEATHS = StatisticList.makeCustomStat("deaths", Counter.DEFAULT);
    public static final MinecraftKey MOB_KILLS = StatisticList.makeCustomStat("mob_kills", Counter.DEFAULT);
    public static final MinecraftKey ANIMALS_BRED = StatisticList.makeCustomStat("animals_bred", Counter.DEFAULT);
    public static final MinecraftKey PLAYER_KILLS = StatisticList.makeCustomStat("player_kills", Counter.DEFAULT);
    public static final MinecraftKey FISH_CAUGHT = StatisticList.makeCustomStat("fish_caught", Counter.DEFAULT);
    public static final MinecraftKey TALKED_TO_VILLAGER = StatisticList.makeCustomStat("talked_to_villager", Counter.DEFAULT);
    public static final MinecraftKey TRADED_WITH_VILLAGER = StatisticList.makeCustomStat("traded_with_villager", Counter.DEFAULT);
    public static final MinecraftKey EAT_CAKE_SLICE = StatisticList.makeCustomStat("eat_cake_slice", Counter.DEFAULT);
    public static final MinecraftKey FILL_CAULDRON = StatisticList.makeCustomStat("fill_cauldron", Counter.DEFAULT);
    public static final MinecraftKey USE_CAULDRON = StatisticList.makeCustomStat("use_cauldron", Counter.DEFAULT);
    public static final MinecraftKey CLEAN_ARMOR = StatisticList.makeCustomStat("clean_armor", Counter.DEFAULT);
    public static final MinecraftKey CLEAN_BANNER = StatisticList.makeCustomStat("clean_banner", Counter.DEFAULT);
    public static final MinecraftKey CLEAN_SHULKER_BOX = StatisticList.makeCustomStat("clean_shulker_box", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_BREWINGSTAND = StatisticList.makeCustomStat("interact_with_brewingstand", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_BEACON = StatisticList.makeCustomStat("interact_with_beacon", Counter.DEFAULT);
    public static final MinecraftKey INSPECT_DROPPER = StatisticList.makeCustomStat("inspect_dropper", Counter.DEFAULT);
    public static final MinecraftKey INSPECT_HOPPER = StatisticList.makeCustomStat("inspect_hopper", Counter.DEFAULT);
    public static final MinecraftKey INSPECT_DISPENSER = StatisticList.makeCustomStat("inspect_dispenser", Counter.DEFAULT);
    public static final MinecraftKey PLAY_NOTEBLOCK = StatisticList.makeCustomStat("play_noteblock", Counter.DEFAULT);
    public static final MinecraftKey TUNE_NOTEBLOCK = StatisticList.makeCustomStat("tune_noteblock", Counter.DEFAULT);
    public static final MinecraftKey POT_FLOWER = StatisticList.makeCustomStat("pot_flower", Counter.DEFAULT);
    public static final MinecraftKey TRIGGER_TRAPPED_CHEST = StatisticList.makeCustomStat("trigger_trapped_chest", Counter.DEFAULT);
    public static final MinecraftKey OPEN_ENDERCHEST = StatisticList.makeCustomStat("open_enderchest", Counter.DEFAULT);
    public static final MinecraftKey ENCHANT_ITEM = StatisticList.makeCustomStat("enchant_item", Counter.DEFAULT);
    public static final MinecraftKey PLAY_RECORD = StatisticList.makeCustomStat("play_record", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_FURNACE = StatisticList.makeCustomStat("interact_with_furnace", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_CRAFTING_TABLE = StatisticList.makeCustomStat("interact_with_crafting_table", Counter.DEFAULT);
    public static final MinecraftKey OPEN_CHEST = StatisticList.makeCustomStat("open_chest", Counter.DEFAULT);
    public static final MinecraftKey SLEEP_IN_BED = StatisticList.makeCustomStat("sleep_in_bed", Counter.DEFAULT);
    public static final MinecraftKey OPEN_SHULKER_BOX = StatisticList.makeCustomStat("open_shulker_box", Counter.DEFAULT);
    public static final MinecraftKey OPEN_BARREL = StatisticList.makeCustomStat("open_barrel", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_BLAST_FURNACE = StatisticList.makeCustomStat("interact_with_blast_furnace", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_SMOKER = StatisticList.makeCustomStat("interact_with_smoker", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_LECTERN = StatisticList.makeCustomStat("interact_with_lectern", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_CAMPFIRE = StatisticList.makeCustomStat("interact_with_campfire", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_CARTOGRAPHY_TABLE = StatisticList.makeCustomStat("interact_with_cartography_table", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_LOOM = StatisticList.makeCustomStat("interact_with_loom", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_STONECUTTER = StatisticList.makeCustomStat("interact_with_stonecutter", Counter.DEFAULT);
    public static final MinecraftKey BELL_RING = StatisticList.makeCustomStat("bell_ring", Counter.DEFAULT);
    public static final MinecraftKey RAID_TRIGGER = StatisticList.makeCustomStat("raid_trigger", Counter.DEFAULT);
    public static final MinecraftKey RAID_WIN = StatisticList.makeCustomStat("raid_win", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_ANVIL = StatisticList.makeCustomStat("interact_with_anvil", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_GRINDSTONE = StatisticList.makeCustomStat("interact_with_grindstone", Counter.DEFAULT);
    public static final MinecraftKey TARGET_HIT = StatisticList.makeCustomStat("target_hit", Counter.DEFAULT);
    public static final MinecraftKey INTERACT_WITH_SMITHING_TABLE = StatisticList.makeCustomStat("interact_with_smithing_table", Counter.DEFAULT);

    private static MinecraftKey makeCustomStat(String var0, Counter var1) {
        MinecraftKey var2 = new MinecraftKey(var0);
        IRegistry.register(IRegistry.CUSTOM_STAT, var0, var2);
        CUSTOM.get(var2, var1);
        return var2;
    }

    private static <T> StatisticWrapper<T> makeRegistryStatType(String var0, IRegistry<T> var1) {
        return IRegistry.register(IRegistry.STAT_TYPE, var0, new StatisticWrapper<T>(var1));
    }
}

