/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ResourceDataJson
extends ResourceDataAbstract<Map<MinecraftKey, JsonElement>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String directory;

    public ResourceDataJson(Gson var0, String var1) {
        this.gson = var0;
        this.directory = var1;
    }

    @Override
    protected Map<MinecraftKey, JsonElement> prepare(IResourceManager var02, GameProfilerFiller var1) {
        HashMap var2 = Maps.newHashMap();
        int var3 = this.directory.length() + 1;
        for (MinecraftKey var5 : var02.listResources(this.directory, var0 -> var0.endsWith(PATH_SUFFIX))) {
            String var6 = var5.getPath();
            MinecraftKey var7 = new MinecraftKey(var5.getNamespace(), var6.substring(var3, var6.length() - PATH_SUFFIX_LENGTH));
            try {
                IResource var8 = var02.getResource(var5);
                try {
                    InputStream var9 = var8.getInputStream();
                    try (BufferedReader var10 = new BufferedReader(new InputStreamReader(var9, StandardCharsets.UTF_8));){
                        JsonElement var11 = ChatDeserializer.fromJson(this.gson, (Reader)var10, JsonElement.class);
                        if (var11 != null) {
                            JsonElement var12 = var2.put(var7, var11);
                            if (var12 == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + var7);
                        }
                        LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)var7, (Object)var5);
                    }
                    finally {
                        if (var9 == null) continue;
                        var9.close();
                    }
                }
                finally {
                    if (var8 == null) continue;
                    var8.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var8) {
                LOGGER.error("Couldn't parse data file {} from {}", (Object)var7, (Object)var5, (Object)var8);
            }
        }
        return var2;
    }

    @Override
    protected /* synthetic */ Object prepare(IResourceManager iResourceManager, GameProfilerFiller gameProfilerFiller) {
        return this.prepare(iResourceManager, gameProfilerFiller);
    }
}

