/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.NetworkManagerServer;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.LegacyPingHandler;
import net.minecraft.server.network.MemoryServerHandshakePacketListenerImpl;
import net.minecraft.util.LazyInitVar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerConnection {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final LazyInitVar<NioEventLoopGroup> SERVER_EVENT_GROUP = new LazyInitVar<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Server IO #%d").setDaemon(true).build()));
    public static final LazyInitVar<EpollEventLoopGroup> SERVER_EPOLL_EVENT_GROUP = new LazyInitVar<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Server IO #%d").setDaemon(true).build()));
    final MinecraftServer server;
    public volatile boolean running;
    private final List<ChannelFuture> channels = Collections.synchronizedList(Lists.newArrayList());
    final List<NetworkManager> connections = Collections.synchronizedList(Lists.newArrayList());

    public ServerConnection(MinecraftServer var0) {
        this.server = var0;
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTcpServerListener(@Nullable InetAddress var0, int var1) throws IOException {
        List<ChannelFuture> list = this.channels;
        synchronized (list) {
            LazyInitVar<NioEventLoopGroup> var4;
            Class<NioServerSocketChannel> var3;
            if (Epoll.isAvailable() && this.server.isEpollEnabled()) {
                var3 = EpollServerSocketChannel.class;
                var4 = SERVER_EPOLL_EVENT_GROUP;
                LOGGER.info("Using epoll channel type");
            } else {
                var3 = NioServerSocketChannel.class;
                var4 = SERVER_EVENT_GROUP;
                LOGGER.info("Using default channel type");
            }
            this.channels.add(((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(var3)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel var0) {
                    try {
                        var0.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    var0.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(ServerConnection.this)).addLast("splitter", (ChannelHandler)new PacketSplitter()).addLast("decoder", (ChannelHandler)new PacketDecoder(EnumProtocolDirection.SERVERBOUND)).addLast("prepender", (ChannelHandler)new PacketPrepender()).addLast("encoder", (ChannelHandler)new PacketEncoder(EnumProtocolDirection.CLIENTBOUND));
                    int var1 = ServerConnection.this.server.getRateLimitPacketsPerSecond();
                    NetworkManager var2 = var1 > 0 ? new NetworkManagerServer(var1) : new NetworkManager(EnumProtocolDirection.SERVERBOUND);
                    ServerConnection.this.connections.add(var2);
                    var0.pipeline().addLast("packet_handler", (ChannelHandler)var2);
                    var2.setListener(new HandshakeListener(ServerConnection.this.server, var2));
                }
            }).group((EventLoopGroup)var4.get()).localAddress(var0, var1)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress startMemoryChannel() {
        ChannelFuture var0;
        List<ChannelFuture> list = this.channels;
        synchronized (list) {
            var0 = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel var0) {
                    NetworkManager var1 = new NetworkManager(EnumProtocolDirection.SERVERBOUND);
                    var1.setListener(new MemoryServerHandshakePacketListenerImpl(ServerConnection.this.server, var1));
                    ServerConnection.this.connections.add(var1);
                    var0.pipeline().addLast("packet_handler", (ChannelHandler)var1);
                }
            }).group((EventLoopGroup)SERVER_EVENT_GROUP.get()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.channels.add(var0);
        }
        return var0.channel().localAddress();
    }

    public void stop() {
        this.running = false;
        for (ChannelFuture var1 : this.channels) {
            try {
                var1.channel().close().sync();
            }
            catch (InterruptedException var2) {
                LOGGER.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<NetworkManager> list = this.connections;
        synchronized (list) {
            Iterator<NetworkManager> var1 = this.connections.iterator();
            while (var1.hasNext()) {
                NetworkManager var22 = var1.next();
                if (var22.isConnecting()) continue;
                if (var22.isConnected()) {
                    try {
                        var22.tick();
                    }
                    catch (Exception var3) {
                        if (var22.isMemoryConnection()) {
                            throw new ReportedException(CrashReport.forThrowable(var3, "Ticking memory connection"));
                        }
                        LOGGER.warn("Failed to handle packet for {}", (Object)var22.getRemoteAddress(), (Object)var3);
                        ChatComponentText var4 = new ChatComponentText("Internal server error");
                        var22.send(new PacketPlayOutKickDisconnect(var4), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)var2 -> var22.disconnect(var4)));
                        var22.setReadOnly();
                    }
                    continue;
                }
                var1.remove();
                var22.handleDisconnection();
            }
        }
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public List<NetworkManager> getConnections() {
        return this.connections;
    }

    static class LatencySimulator
    extends ChannelInboundHandlerAdapter {
        private static final Timer TIMER = new HashedWheelTimer();
        private final int delay;
        private final int jitter;
        private final List<DelayedMessage> queuedMessages = Lists.newArrayList();

        public LatencySimulator(int var0, int var1) {
            this.delay = var0;
            this.jitter = var1;
        }

        public void channelRead(ChannelHandlerContext var0, Object var1) {
            this.delayDownstream(var0, var1);
        }

        private void delayDownstream(ChannelHandlerContext var0, Object var1) {
            int var2 = this.delay + (int)(Math.random() * (double)this.jitter);
            this.queuedMessages.add(new DelayedMessage(var0, var1));
            TIMER.newTimeout(this::onTimeout, (long)var2, TimeUnit.MILLISECONDS);
        }

        private void onTimeout(Timeout var0) {
            DelayedMessage var1 = this.queuedMessages.remove(0);
            var1.ctx.fireChannelRead(var1.msg);
        }

        static class DelayedMessage {
            public final ChannelHandlerContext ctx;
            public final Object msg;

            public DelayedMessage(ChannelHandlerContext var0, Object var1) {
                this.ctx = var0;
                this.msg = var1;
            }
        }
    }
}

