/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.level.ChunkCoordIntPair;

public class ChunkTaskQueue<T> {
    public static final int PRIORITY_LEVEL_COUNT = PlayerChunkMap.MAX_CHUNK_DISTANCE + 2;
    private final List<Long2ObjectLinkedOpenHashMap<List<Optional<T>>>> taskQueue = IntStream.range(0, PRIORITY_LEVEL_COUNT).mapToObj(var0 -> new Long2ObjectLinkedOpenHashMap()).collect(Collectors.toList());
    private volatile int firstQueue = PRIORITY_LEVEL_COUNT;
    private final String name;
    private final LongSet acquired = new LongOpenHashSet();
    private final int maxTasks;

    public ChunkTaskQueue(String var02, int var1) {
        this.name = var02;
        this.maxTasks = var1;
    }

    protected void resortChunkTasks(int var02, ChunkCoordIntPair var1, int var2) {
        if (var02 >= PRIORITY_LEVEL_COUNT) {
            return;
        }
        Long2ObjectLinkedOpenHashMap<List<Optional<T>>> var3 = this.taskQueue.get(var02);
        List var4 = (List)var3.remove(var1.toLong());
        if (var02 == this.firstQueue) {
            while (this.firstQueue < PRIORITY_LEVEL_COUNT && this.taskQueue.get(this.firstQueue).isEmpty()) {
                ++this.firstQueue;
            }
        }
        if (var4 != null && !var4.isEmpty()) {
            ((List)this.taskQueue.get(var2).computeIfAbsent(var1.toLong(), var0 -> Lists.newArrayList())).addAll(var4);
            this.firstQueue = Math.min(this.firstQueue, var2);
        }
    }

    protected void submit(Optional<T> var02, long var1, int var3) {
        ((List)this.taskQueue.get(var3).computeIfAbsent(var1, var0 -> Lists.newArrayList())).add(var02);
        this.firstQueue = Math.min(this.firstQueue, var3);
    }

    protected void release(long var02, boolean var2) {
        for (Long2ObjectLinkedOpenHashMap<List<Optional<T>>> var4 : this.taskQueue) {
            List var5 = (List)var4.get(var02);
            if (var5 == null) continue;
            if (var2) {
                var5.clear();
            } else {
                var5.removeIf(var0 -> !var0.isPresent());
            }
            if (!var5.isEmpty()) continue;
            var4.remove(var02);
        }
        while (this.firstQueue < PRIORITY_LEVEL_COUNT && this.taskQueue.get(this.firstQueue).isEmpty()) {
            ++this.firstQueue;
        }
        this.acquired.remove(var02);
    }

    private Runnable acquire(long var0) {
        return () -> this.acquired.add(var0);
    }

    @Nullable
    public Stream<Either<T, Runnable>> pop() {
        if (this.acquired.size() >= this.maxTasks) {
            return null;
        }
        if (this.firstQueue < PRIORITY_LEVEL_COUNT) {
            int var0 = this.firstQueue;
            Long2ObjectLinkedOpenHashMap<List<Optional<T>>> var1 = this.taskQueue.get(var0);
            long var22 = var1.firstLongKey();
            List var4 = (List)var1.removeFirst();
            while (this.firstQueue < PRIORITY_LEVEL_COUNT && this.taskQueue.get(this.firstQueue).isEmpty()) {
                ++this.firstQueue;
            }
            return var4.stream().map(var2 -> var2.map(Either::left).orElseGet(() -> Either.right((Object)this.acquire(var22))));
        }
        return null;
    }

    public String toString() {
        return this.name + " " + this.firstQueue + "...";
    }

    @VisibleForTesting
    LongSet getAcquired() {
        return new LongOpenHashSet((LongCollection)this.acquired);
    }
}

