/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.EnumGamemode;

public class CommandSpectate {
    private static final SimpleCommandExceptionType ERROR_SELF = new SimpleCommandExceptionType((Message)new ChatMessage("commands.spectate.self"));
    private static final DynamicCommandExceptionType ERROR_NOT_SPECTATOR = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.spectate.not_spectator", var0));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spectate").requires(var0 -> var0.hasPermission(2))).executes(var0 -> CommandSpectate.spectate((CommandListenerWrapper)var0.getSource(), null, ((CommandListenerWrapper)var0.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.entity()).executes(var0 -> CommandSpectate.spectate((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ((CommandListenerWrapper)var0.getSource()).getPlayerOrException()))).then(net.minecraft.commands.CommandDispatcher.argument("player", ArgumentEntity.player()).executes(var0 -> CommandSpectate.spectate((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), ArgumentEntity.getPlayer((CommandContext<CommandListenerWrapper>)var0, "player"))))));
    }

    private static int spectate(CommandListenerWrapper var0, @Nullable Entity var1, EntityPlayer var2) throws CommandSyntaxException {
        if (var2 == var1) {
            throw ERROR_SELF.create();
        }
        if (var2.gameMode.getGameModeForPlayer() != EnumGamemode.SPECTATOR) {
            throw ERROR_NOT_SPECTATOR.create((Object)var2.getDisplayName());
        }
        var2.setCamera(var1);
        if (var1 != null) {
            var0.sendSuccess(new ChatMessage("commands.spectate.success.started", var1.getDisplayName()), false);
        } else {
            var0.sendSuccess(new ChatMessage("commands.spectate.success.stopped"), false);
        }
        return 1;
    }
}

