/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandSetBlock {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new ChatMessage("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var03) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("setblock").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("block", ArgumentTile.block()).executes(var0 -> CommandSetBlock.setBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, null))).then(net.minecraft.commands.CommandDispatcher.literal("destroy").executes(var0 -> CommandSetBlock.setBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.DESTROY, null)))).then(net.minecraft.commands.CommandDispatcher.literal("keep").executes(var02 -> CommandSetBlock.setBlock((CommandListenerWrapper)var02.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var02, "block"), Mode.REPLACE, var0 -> var0.getLevel().isEmptyBlock(var0.getPos()))))).then(net.minecraft.commands.CommandDispatcher.literal("replace").executes(var0 -> CommandSetBlock.setBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, null))))));
    }

    private static int setBlock(CommandListenerWrapper var0, BlockPosition var1, ArgumentTileLocation var2, Mode var3, @Nullable Predicate<ShapeDetectorBlock> var4) throws CommandSyntaxException {
        boolean var6;
        WorldServer var5 = var0.getLevel();
        if (var4 != null && !var4.test(new ShapeDetectorBlock(var5, var1, true))) {
            throw ERROR_FAILED.create();
        }
        if (var3 == Mode.DESTROY) {
            var5.destroyBlock(var1, true);
            var6 = !var2.getState().isAir() || !var5.getBlockState(var1).isAir();
        } else {
            TileEntity var7 = var5.getBlockEntity(var1);
            Clearable.tryClear(var7);
            var6 = true;
        }
        if (var6 && !var2.place(var5, var1, 2)) {
            throw ERROR_FAILED.create();
        }
        var5.blockUpdated(var1, var2.getState().getBlock());
        var0.sendSuccess(new ChatMessage("commands.setblock.success", var1.getX(), var1.getY(), var1.getZ()), true);
        return 1;
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode REPLACE = new Mode();
        public static final /* enum */ Mode DESTROY = new Mode();
        private static final /* synthetic */ Mode[] c;

        public static Mode[] values() {
            return (Mode[])c.clone();
        }

        public static Mode valueOf(String var0) {
            return Enum.valueOf(Mode.class, var0);
        }

        private static /* synthetic */ Mode[] a() {
            return new Mode[]{REPLACE, DESTROY};
        }

        static {
            c = Mode.a();
        }
    }

    public static interface Filter {
        @Nullable
        public ArgumentTileLocation filter(StructureBoundingBox var1, BlockPosition var2, ArgumentTileLocation var3, WorldServer var4);
    }
}

