/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.regex.Matcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.commands.CommandBanIp;
import net.minecraft.server.players.IpBanList;

public class CommandPardonIP {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)new ChatMessage("commands.pardonip.invalid"));
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)new ChatMessage("commands.pardonip.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("pardon-ip").requires(var0 -> var0.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.argument("target", StringArgumentType.word()).suggests((var0, var1) -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getIpBans().getUserList(), var1)).executes(var0 -> CommandPardonIP.unban((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"target")))));
    }

    private static int unban(CommandListenerWrapper var0, String var1) throws CommandSyntaxException {
        Matcher var2 = CommandBanIp.IP_ADDRESS_PATTERN.matcher(var1);
        if (!var2.matches()) {
            throw ERROR_INVALID.create();
        }
        IpBanList var3 = var0.getServer().getPlayerList().getIpBans();
        if (!var3.isBanned(var1)) {
            throw ERROR_NOT_BANNED.create();
        }
        var3.remove(var1);
        var0.sendSuccess(new ChatMessage("commands.pardonip.success", var1), true);
        return 1;
    }
}

