/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.tags.TagRegistry;
import net.minecraft.util.Unit;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.storage.loot.ItemModifierManager;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootTableRegistry;

public class DataPackResources
implements AutoCloseable {
    private static final CompletableFuture<Unit> DATA_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private final IReloadableResourceManager resources = new ResourceManager(EnumResourcePackType.SERVER_DATA);
    public CommandDispatcher commands;
    private final CraftingManager recipes = new CraftingManager();
    private final TagRegistry tagManager;
    private final LootPredicateManager predicateManager = new LootPredicateManager();
    private final LootTableRegistry lootTables = new LootTableRegistry(this.predicateManager);
    private final ItemModifierManager itemModifierManager = new ItemModifierManager(this.predicateManager, this.lootTables);
    private final AdvancementDataWorld advancements = new AdvancementDataWorld(this.predicateManager);
    private final CustomFunctionManager functionLibrary;

    public DataPackResources(IRegistryCustom var0, CommandDispatcher.ServerType var1, int var2) {
        this.tagManager = new TagRegistry(var0);
        this.commands = new CommandDispatcher(var1);
        this.functionLibrary = new CustomFunctionManager(var2, this.commands.getDispatcher());
        this.resources.registerReloadListener(this.tagManager);
        this.resources.registerReloadListener(this.predicateManager);
        this.resources.registerReloadListener(this.recipes);
        this.resources.registerReloadListener(this.lootTables);
        this.resources.registerReloadListener(this.itemModifierManager);
        this.resources.registerReloadListener(this.functionLibrary);
        this.resources.registerReloadListener(this.advancements);
    }

    public CustomFunctionManager getFunctionLibrary() {
        return this.functionLibrary;
    }

    public LootPredicateManager getPredicateManager() {
        return this.predicateManager;
    }

    public LootTableRegistry getLootTables() {
        return this.lootTables;
    }

    public ItemModifierManager getItemModifierManager() {
        return this.itemModifierManager;
    }

    public ITagRegistry getTags() {
        return this.tagManager.getTags();
    }

    public CraftingManager getRecipeManager() {
        return this.recipes;
    }

    public CommandDispatcher getCommands() {
        return this.commands;
    }

    public AdvancementDataWorld getAdvancements() {
        return this.advancements;
    }

    public IResourceManager getResourceManager() {
        return this.resources;
    }

    public static CompletableFuture<DataPackResources> loadResources(List<IResourcePack> var0, IRegistryCustom var12, CommandDispatcher.ServerType var22, int var3, Executor var4, Executor var5) {
        DataPackResources var6 = new DataPackResources(var12, var22, var3);
        CompletableFuture<Unit> var7 = var6.resources.reload(var4, var5, var0, DATA_RELOAD_INITIAL_TASK);
        return ((CompletableFuture)var7.whenComplete((var1, var2) -> {
            if (var2 != null) {
                var6.close();
            }
        })).thenApply(var1 -> var6);
    }

    public void updateGlobals() {
        this.tagManager.getTags().bindToGlobal();
    }

    @Override
    public void close() {
        this.resources.close();
    }
}

