/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.Tags;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomFunctionManager
implements IReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FILE_EXTENSION = ".mcfunction";
    private static final int PATH_PREFIX_LENGTH = "functions/".length();
    private static final int PATH_SUFFIX_LENGTH = ".mcfunction".length();
    private volatile Map<MinecraftKey, CustomFunction> functions = ImmutableMap.of();
    private final TagDataPack<CustomFunction> tagsLoader = new TagDataPack(this::getFunction, "tags/functions");
    private volatile Tags<CustomFunction> tags = Tags.empty();
    private final int functionCompilationLevel;
    private final CommandDispatcher<CommandListenerWrapper> dispatcher;

    public Optional<CustomFunction> getFunction(MinecraftKey var0) {
        return Optional.ofNullable(this.functions.get(var0));
    }

    public Map<MinecraftKey, CustomFunction> getFunctions() {
        return this.functions;
    }

    public Tags<CustomFunction> getTags() {
        return this.tags;
    }

    public Tag<CustomFunction> getTag(MinecraftKey var0) {
        return this.tags.getTagOrEmpty(var0);
    }

    public CustomFunctionManager(int var0, CommandDispatcher<CommandListenerWrapper> var1) {
        this.functionCompilationLevel = var0;
        this.dispatcher = var1;
    }

    @Override
    public CompletableFuture<Void> reload(IReloadListener.a var02, IResourceManager var1, GameProfilerFiller var2, GameProfilerFiller var3, Executor var4, Executor var5) {
        CompletableFuture<Map> var6 = CompletableFuture.supplyAsync(() -> this.tagsLoader.load(var1), var4);
        CompletionStage var7 = CompletableFuture.supplyAsync(() -> var1.listResources("functions", var0 -> var0.endsWith(FILE_EXTENSION)), var4).thenCompose(var22 -> {
            HashMap var3 = Maps.newHashMap();
            CommandListenerWrapper var4 = new CommandListenerWrapper(ICommandListener.NULL, Vec3D.ZERO, Vec2F.ZERO, null, this.functionCompilationLevel, "", ChatComponentText.EMPTY, null, null);
            for (MinecraftKey var6 : var22) {
                String var7 = var6.getPath();
                MinecraftKey var8 = new MinecraftKey(var6.getNamespace(), var7.substring(PATH_PREFIX_LENGTH, var7.length() - PATH_SUFFIX_LENGTH));
                var3.put(var8, CompletableFuture.supplyAsync(() -> {
                    List<String> var4 = CustomFunctionManager.readLines(var1, var6);
                    return CustomFunction.fromLines(var8, this.dispatcher, var4, var4);
                }, var4));
            }
            CompletableFuture[] var5 = var3.values().toArray(new CompletableFuture[0]);
            return CompletableFuture.allOf(var5).handle((var1, var2) -> var3);
        });
        return ((CompletableFuture)((CompletableFuture)var6.thenCombine(var7, Pair::of)).thenCompose(var02::wait)).thenAcceptAsync(var0 -> {
            Map var12 = (Map)var0.getSecond();
            ImmutableMap.Builder var2 = ImmutableMap.builder();
            var12.forEach((var1, var22) -> ((CompletableFuture)var22.handle((var2, var3) -> {
                if (var3 != null) {
                    LOGGER.error("Failed to load function {}", var1, var3);
                } else {
                    var2.put(var1, var2);
                }
                return null;
            })).join());
            this.functions = var2.build();
            this.tags = this.tagsLoader.build((Map)var0.getFirst());
        }, var5);
    }

    private static List<String> readLines(IResourceManager var0, MinecraftKey var1) {
        List list;
        block8: {
            IResource var2 = var0.getResource(var1);
            try {
                list = IOUtils.readLines((InputStream)var2.getInputStream(), (Charset)StandardCharsets.UTF_8);
                if (var2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (var2 != null) {
                        try {
                            var2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException var22) {
                    throw new CompletionException(var22);
                }
            }
            var2.close();
        }
        return list;
    }
}

